/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.expression;

import java.math.BigInteger;
import java.util.Objects;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.parser.ASTNodeAccessImpl;

public class LongValue
extends ASTNodeAccessImpl
implements Expression {
    private String stringValue;

    public LongValue() {
    }

    public LongValue(String value) {
        String val = value;
        if (val.charAt(0) == '+') {
            val = val.substring(1);
        }
        this.stringValue = val;
    }

    public LongValue(long value) {
        this.stringValue = String.valueOf(value);
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public long getValue() {
        return Long.parseLong(this.stringValue);
    }

    public BigInteger getBigIntegerValue() {
        return new BigInteger(this.stringValue);
    }

    public void setValue(long d2) {
        this.stringValue = String.valueOf(d2);
    }

    public LongValue withValue(long d2) {
        this.setValue(d2);
        return this;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public void setStringValue(String string) {
        this.stringValue = string;
    }

    public String toString() {
        return this.getStringValue();
    }

    public LongValue withStringValue(String stringValue) {
        this.setStringValue(stringValue);
        return this;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        LongValue longValue = (LongValue)o2;
        return this.stringValue.equals(longValue.stringValue);
    }

    public int hashCode() {
        return Objects.hash(this.stringValue);
    }
}

