/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.parser.feature;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.jsqlparser.parser.feature.Feature;

public class FeatureConfiguration {
    private static final Logger LOG = Logger.getLogger(FeatureConfiguration.class.getName());
    private Map<Feature, Object> featureEnabled = new EnumMap<Feature, Object>(Feature.class);

    public FeatureConfiguration() {
        EnumSet.allOf(Feature.class).stream().filter(Feature::isConfigurable).forEach(f2 -> this.setValue((Feature)((Object)f2), f2.getDefaultValue()));
    }

    public FeatureConfiguration setValue(Feature feature, Object value) {
        if (feature.isConfigurable()) {
            this.featureEnabled.put(feature, value);
        } else if (LOG.isLoggable(Level.WARNING)) {
            LOG.warning(feature.name() + " is not switchable - cannot set enabled = " + value);
        }
        return this;
    }

    public Object getValue(Feature feature) {
        if (feature.isConfigurable()) {
            return this.featureEnabled.get((Object)feature);
        }
        throw new IllegalStateException("The feature " + (Object)((Object)feature) + " is not configurable!");
    }

    public boolean getAsBoolean(Feature f2) {
        return Boolean.valueOf(String.valueOf(this.getValue(f2)));
    }

    public String getAsString(Feature f2) {
        Object value = this.getValue(f2);
        return value == null ? null : String.valueOf(value);
    }
}

