/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.util.Map;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.ACProxyable;
import oracle.jdbc.internal.OracleConcreteProxy;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.proxy.ProxyFactory;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyAccess;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;
import oracle.jdbc.replay.driver.JDBCReplayable;
import oracle.jdbc.replay.driver.TxnFailoverManagerImpl;
import oracle.jdbc.replay.driver.TxnReplayableBase;
import oracle.sql.BFILE;

@ProxyFor(value={oracle.jdbc.internal.OracleResultSet.class})
@ProxyAccess(value=ACProxyable.class)
@DefaultLogger(value="oracle.jdbc.internal.replay")
@Supports(value={Feature.APPLICATION_CONTINUITY})
public abstract class TxnReplayableResultSet
extends TxnReplayableBase
implements JDBCReplayable {
    private static final Method GETCLOB_METHOD = TxnReplayableResultSet.getGetLobMethod("getClob", Integer.TYPE);
    private static final Method GETCLOB_WITH_NAME_METHOD = TxnReplayableResultSet.getGetLobMethod("getClob", String.class);
    private static final Method GETNCLOB_METHOD = TxnReplayableResultSet.getGetLobMethod("getNClob", Integer.TYPE);
    private static final Method GETNCLOB_WITH_NAME_METHOD = TxnReplayableResultSet.getGetLobMethod("getNClob", String.class);
    private static final Method GETBLOB_METHOD = TxnReplayableResultSet.getGetLobMethod("getBlob", Integer.TYPE);
    private static final Method GETBLOB_WITH_NAME_METHOD = TxnReplayableResultSet.getGetLobMethod("getBlob", String.class);
    private static final Method GETBFILE_METHOD = TxnReplayableResultSet.getGetLobMethod("getBfile", Integer.TYPE);
    private static final Method GETBFILE_WITH_NAME_METHOD = TxnReplayableResultSet.getGetLobMethod("getBfile", String.class);
    private static final Method GETOBJECT_METHOD = TxnReplayableResultSet.getMethod("getObject", Integer.TYPE);
    private static final Method GETOBJECT_WITH_TYPE_METHOD = TxnReplayableResultSet.getMethod("getObject", Integer.TYPE, Class.class);
    private static final Method GETOBJECT_WITH_MAP_METHOD = TxnReplayableResultSet.getMethod("getObject", Integer.TYPE, Map.class);
    private static final Method GETOBJECT_WITH_NAME_METHOD = TxnReplayableResultSet.getMethod("getObject", String.class);
    private static final Method GETOBJECT_WITH_NAME_AND_TYPE_METHOD = TxnReplayableResultSet.getMethod("getObject", String.class, Class.class);
    private static final Method GETOBJECT_WITH_NAME_AND_MAP_METHOD = TxnReplayableResultSet.getMethod("getObject", String.class, Map.class);
    private static final Method GETREF_METHOD = TxnReplayableResultSet.getMethod("getRef", Integer.TYPE);
    private static final Method GETREF_WITH_NAME_METHOD = TxnReplayableResultSet.getMethod("getRef", String.class);
    private static final Method GETARRAY_METHOD = TxnReplayableResultSet.getMethod("getArray", Integer.TYPE);
    private static final Method GETARRAY_WITH_NAME_METHOD = TxnReplayableResultSet.getMethod("getArray", String.class);

    protected TxnReplayableResultSet() {
        this.thisProxyNameInLog = "RSET" + this.thisProxyNameInLog;
    }

    @Override
    @Pre
    protected void preForAll(Method method, Object object, Object ... objectArray) {
        super.preForAll(method, object, objectArray);
    }

    @Pre
    @Methods(signatures={@Signature(name="getAsciiStream", args={int.class}), @Signature(name="getBinaryStream", args={int.class}), @Signature(name="getCharacterStream", args={int.class}), @Signature(name="getNCharacterStream", args={int.class})})
    protected void preForGetStreams(Method method, Object object, Object ... objectArray) {
        try {
            int n2;
            ResultSetMetaData resultSetMetaData = ((ResultSet)this.getDelegate()).getMetaData();
            if (resultSetMetaData != null && ((n2 = resultSetMetaData.getColumnType((Integer)objectArray[0])) == 2004 || n2 == 2005 || n2 == -13 || n2 == 2016)) {
                this.failoverMngr.setLobStreamInRequest(true);
                this.failoverMngr.disableReplayInternal(method, 372, "Replay disabled because of nonreplayable call", null);
            }
        }
        catch (Throwable throwable) {
        }
        this.preForAll(method, object, objectArray);
    }

    @Pre
    @Methods(signatures={@Signature(name="getAsciiStream", args={String.class}), @Signature(name="getBinaryStream", args={String.class}), @Signature(name="getCharacterStream", args={String.class}), @Signature(name="getNCharacterStream", args={String.class})})
    protected void preForGetStreamsByColumnName(Method method, Object object, Object ... objectArray) {
        try {
            int n2;
            ResultSet resultSet = (ResultSet)this.getDelegate();
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            if (resultSetMetaData != null && ((n2 = resultSetMetaData.getColumnType(resultSet.findColumn((String)objectArray[0]))) == 2004 || n2 == 2005 || n2 == -13 || n2 == 2016)) {
                this.failoverMngr.setLobStreamInRequest(true);
                this.failoverMngr.disableReplayInternal(method, 372, "Replay disabled because of nonreplayable call", null);
            }
        }
        catch (Throwable throwable) {
        }
        this.preForAll(method, object, objectArray);
    }

    @Pre
    @Methods(signatures={@Signature(name="getOPAQUE", args={int.class}), @Signature(name="getOPAQUE", args={String.class})})
    protected void preForMethodWithConcreteClass(Method method, Object object, Object ... objectArray) {
        block1: {
            TxnFailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
            if (replayLifecycle != TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
                return;
            }
            if (this.failoverMngr == null) break block1;
            this.failoverMngr.disableReplayInternal(method, 397, "Replay disabled because of concrete class usage", null);
        }
    }

    @Pre
    @Methods(signatures={@Signature(name="updateAsciiStream", args={String.class, InputStream.class}), @Signature(name="updateAsciiStream", args={String.class, InputStream.class, int.class}), @Signature(name="updateAsciiStream", args={String.class, InputStream.class, long.class}), @Signature(name="updateBinaryStream", args={String.class, InputStream.class}), @Signature(name="updateBinaryStream", args={String.class, InputStream.class, int.class}), @Signature(name="updateBinaryStream", args={String.class, InputStream.class, long.class}), @Signature(name="updateCharacterStream", args={String.class, Reader.class}), @Signature(name="updateCharacterStream", args={String.class, Reader.class, int.class}), @Signature(name="updateCharacterStream", args={String.class, Reader.class, long.class}), @Signature(name="updateNCharacterStream", args={String.class, Reader.class}), @Signature(name="updateNCharacterStream", args={String.class, Reader.class, long.class}), @Signature(name="updateAsciiStream", args={int.class, InputStream.class}), @Signature(name="updateAsciiStream", args={int.class, InputStream.class, int.class}), @Signature(name="updateAsciiStream", args={int.class, InputStream.class, long.class}), @Signature(name="updateBinaryStream", args={int.class, InputStream.class}), @Signature(name="updateBinaryStream", args={int.class, InputStream.class, int.class}), @Signature(name="updateBinaryStream", args={int.class, InputStream.class, long.class}), @Signature(name="updateCharacterStream", args={int.class, Reader.class}), @Signature(name="updateCharacterStream", args={int.class, Reader.class, int.class}), @Signature(name="updateCharacterStream", args={int.class, Reader.class, long.class}), @Signature(name="updateNCharacterStream", args={int.class, Reader.class}), @Signature(name="updateNCharacterStream", args={int.class, Reader.class, long.class})})
    protected void preForUpdateStreams(Method method, Object object, Object ... objectArray) {
        block1: {
            TxnFailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
            if (replayLifecycle != TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
                return;
            }
            if (this.failoverMngr == null) break block1;
            this.failoverMngr.disableReplayInternal(method, 371, "Replay disabled because of active transaction", null);
        }
    }

    @Override
    @Post
    protected void postForAll(Method method) {
        this.postForAll(method, null);
    }

    @Override
    @Post
    protected Object postForAll(Method method, Object object) {
        return super.postForAll(method, object);
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Clob getClob(int n2) throws SQLException {
        if (GETCLOB_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getClob(int)");
        }
        Method method = GETCLOB_METHOD;
        this.preForAll(method, this, n2);
        try {
            ResultSet resultSet = (ResultSet)this.getDelegate();
            Clob clob = resultSet.getClob(n2);
            return (Clob)this.postForAll(method, clob);
        }
        catch (SQLException sQLException) {
            return (Clob)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Clob getClob(String string) throws SQLException {
        if (GETCLOB_WITH_NAME_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getClob(String)");
        }
        Method method = GETCLOB_WITH_NAME_METHOD;
        this.preForAll(method, this, string);
        try {
            ResultSet resultSet = (ResultSet)this.getDelegate();
            Clob clob = resultSet.getClob(string);
            return (Clob)this.postForAll(method, clob);
        }
        catch (SQLException sQLException) {
            return (Clob)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public NClob getNClob(int n2) throws SQLException {
        if (GETNCLOB_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getNClob(int)");
        }
        Method method = GETNCLOB_METHOD;
        this.preForAll(method, this, n2);
        try {
            ResultSet resultSet = (ResultSet)this.getDelegate();
            NClob nClob = resultSet.getNClob(n2);
            return (NClob)this.postForAll(method, nClob);
        }
        catch (SQLException sQLException) {
            return (NClob)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public NClob getNClob(String string) throws SQLException {
        if (GETNCLOB_WITH_NAME_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getNClob(String)");
        }
        Method method = GETNCLOB_WITH_NAME_METHOD;
        this.preForAll(method, this, string);
        try {
            ResultSet resultSet = (ResultSet)this.getDelegate();
            NClob nClob = resultSet.getNClob(string);
            return (NClob)this.postForAll(method, nClob);
        }
        catch (SQLException sQLException) {
            return (NClob)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Blob getBlob(int n2) throws SQLException {
        if (GETBLOB_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getBlob(int)");
        }
        Method method = GETBLOB_METHOD;
        this.preForAll(method, this, n2);
        try {
            ResultSet resultSet = (ResultSet)this.getDelegate();
            Blob blob = resultSet.getBlob(n2);
            return (Blob)this.postForAll(method, blob);
        }
        catch (SQLException sQLException) {
            return (Blob)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Blob getBlob(String string) throws SQLException {
        if (GETBLOB_WITH_NAME_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getBlob(String)");
        }
        Method method = GETBLOB_WITH_NAME_METHOD;
        this.preForAll(method, this, string);
        try {
            ResultSet resultSet = (ResultSet)this.getDelegate();
            Blob blob = resultSet.getBlob(string);
            return (Blob)this.postForAll(method, blob);
        }
        catch (SQLException sQLException) {
            return (Blob)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public BFILE getBfile(int n2) throws SQLException {
        if (GETBFILE_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getBfile(int)");
        }
        Method method = GETBFILE_METHOD;
        this.preForAll(method, this, n2);
        try {
            OracleResultSet oracleResultSet = (OracleResultSet)this.getDelegate();
            BFILE bFILE = oracleResultSet.getBfile(n2);
            return (BFILE)this.postForAll(method, bFILE);
        }
        catch (SQLException sQLException) {
            return (BFILE)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public BFILE getBfile(String string) throws SQLException {
        if (GETBFILE_WITH_NAME_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getBfile(String)");
        }
        Method method = GETBFILE_WITH_NAME_METHOD;
        this.preForAll(method, this, string);
        try {
            OracleResultSet oracleResultSet = (OracleResultSet)this.getDelegate();
            BFILE bFILE = oracleResultSet.getBfile(string);
            return (BFILE)this.postForAll(method, bFILE);
        }
        catch (SQLException sQLException) {
            return (BFILE)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Object getObject(int n2) throws SQLException {
        if (GETOBJECT_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getObject(int)");
        }
        Method method = GETOBJECT_METHOD;
        this.preForAll(method, this, n2);
        try {
            ProxyFactory proxyFactory;
            ResultSet resultSet = (ResultSet)this.getDelegate();
            Object object = resultSet.getObject(n2);
            if (!(object instanceof OracleConcreteProxy) && (proxyFactory = this.failoverMngr.getProxyFactory()) != null) {
                return this.postForAll(method, proxyFactory.proxyFor(object));
            }
            return this.postForAll(method, object);
        }
        catch (SQLException sQLException) {
            return this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public <T> T getObject(int n2, Class<T> clazz) throws SQLException {
        if (GETOBJECT_WITH_TYPE_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getObject(int,Class<T>)");
        }
        Method method = GETOBJECT_WITH_TYPE_METHOD;
        this.preForAll(method, this, n2, clazz);
        try {
            ProxyFactory proxyFactory;
            ResultSet resultSet = (ResultSet)this.getDelegate();
            T t2 = resultSet.getObject(n2, clazz);
            if (!(t2 instanceof OracleConcreteProxy) && (proxyFactory = this.failoverMngr.getProxyFactory()) != null) {
                return (T)this.postForAll(method, proxyFactory.proxyFor(t2));
            }
            return (T)this.postForAll(method, t2);
        }
        catch (SQLException sQLException) {
            return (T)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Object getObject(int n2, Map<String, Class<?>> map) throws SQLException {
        if (GETOBJECT_WITH_MAP_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getObject(int, Map)");
        }
        Method method = GETOBJECT_WITH_MAP_METHOD;
        this.preForAll(method, this, n2, map);
        try {
            ProxyFactory proxyFactory;
            ResultSet resultSet = (ResultSet)this.getDelegate();
            Object object = resultSet.getObject(n2, map);
            if (!(object instanceof OracleConcreteProxy) && (proxyFactory = this.failoverMngr.getProxyFactory()) != null) {
                return this.postForAll(method, proxyFactory.proxyFor(object));
            }
            return this.postForAll(method, object);
        }
        catch (SQLException sQLException) {
            return this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Object getObject(String string) throws SQLException {
        if (GETOBJECT_WITH_NAME_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getObject(String)");
        }
        Method method = GETOBJECT_WITH_NAME_METHOD;
        this.preForAll(method, this, string);
        try {
            ProxyFactory proxyFactory;
            ResultSet resultSet = (ResultSet)this.getDelegate();
            Object object = resultSet.getObject(string);
            if (!(object instanceof OracleConcreteProxy) && (proxyFactory = this.failoverMngr.getProxyFactory()) != null) {
                return this.postForAll(method, proxyFactory.proxyFor(object));
            }
            return this.postForAll(method, object);
        }
        catch (SQLException sQLException) {
            return this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public <T> T getObject(String string, Class<T> clazz) throws SQLException {
        if (GETOBJECT_WITH_NAME_AND_TYPE_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getObject(String,Class<T>)");
        }
        Method method = GETOBJECT_WITH_NAME_AND_TYPE_METHOD;
        this.preForAll(method, this, string, clazz);
        try {
            ProxyFactory proxyFactory;
            ResultSet resultSet = (ResultSet)this.getDelegate();
            T t2 = resultSet.getObject(string, clazz);
            if (!(t2 instanceof OracleConcreteProxy) && (proxyFactory = this.failoverMngr.getProxyFactory()) != null) {
                return (T)this.postForAll(method, proxyFactory.proxyFor(t2));
            }
            return (T)this.postForAll(method, t2);
        }
        catch (SQLException sQLException) {
            return (T)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Object getObject(String string, Map<String, Class<?>> map) throws SQLException {
        if (GETOBJECT_WITH_NAME_AND_MAP_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getObject(String, Map)");
        }
        Method method = GETOBJECT_WITH_NAME_AND_MAP_METHOD;
        this.preForAll(method, this, string, map);
        try {
            ProxyFactory proxyFactory;
            ResultSet resultSet = (ResultSet)this.getDelegate();
            Object object = resultSet.getObject(string, map);
            if (!(object instanceof OracleConcreteProxy) && (proxyFactory = this.failoverMngr.getProxyFactory()) != null) {
                return this.postForAll(method, proxyFactory.proxyFor(object));
            }
            return this.postForAll(method, object);
        }
        catch (SQLException sQLException) {
            return this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Ref getRef(int n2) throws SQLException {
        if (GETREF_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getRef(int)");
        }
        Method method = GETREF_METHOD;
        this.preForAll(method, this, n2);
        try {
            ResultSet resultSet = (ResultSet)this.getDelegate();
            Ref ref = resultSet.getRef(n2);
            return (Ref)this.postForAll(method, ref);
        }
        catch (SQLException sQLException) {
            return (Ref)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Ref getRef(String string) throws SQLException {
        if (GETREF_WITH_NAME_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getRef(String)");
        }
        Method method = GETREF_WITH_NAME_METHOD;
        this.preForAll(method, this, string);
        try {
            ResultSet resultSet = (ResultSet)this.getDelegate();
            Ref ref = resultSet.getRef(string);
            return (Ref)this.postForAll(method, ref);
        }
        catch (SQLException sQLException) {
            return (Ref)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Array getArray(int n2) throws SQLException {
        if (GETARRAY_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getArray(int)");
        }
        Method method = GETARRAY_METHOD;
        this.preForAll(method, this, n2);
        try {
            ResultSet resultSet = (ResultSet)this.getDelegate();
            Array array = resultSet.getArray(n2);
            return (Array)this.postForAll(method, array);
        }
        catch (SQLException sQLException) {
            return (Array)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Array getArray(String string) throws SQLException {
        if (GETARRAY_WITH_NAME_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getArray(String)");
        }
        Method method = GETARRAY_WITH_NAME_METHOD;
        this.preForAll(method, this, string);
        try {
            ResultSet resultSet = (ResultSet)this.getDelegate();
            Array array = resultSet.getArray(string);
            return (Array)this.postForAll(method, array);
        }
        catch (SQLException sQLException) {
            return (Array)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    private static final Method getGetLobMethod(String string, Class<?> clazz) {
        try {
            return oracle.jdbc.internal.OracleResultSet.class.getMethod(string, clazz);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final Method getMethod(String string, Class<?> ... classArray) {
        try {
            return oracle.jdbc.internal.OracleResultSet.class.getMethod(string, classArray);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Post
    @Methods(signatures={@Signature(name="close", args={})})
    protected void postForClose(Method method) {
        this.postForAll(method);
        TxnFailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        if (replayLifecycle == TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            this.isLogicallyClosed = true;
        }
    }

    @Override
    @OnError(value=SQLException.class)
    protected void onErrorVoidForAll(Method method, SQLException sQLException) throws SQLException {
        this.onErrorForAll(method, sQLException);
    }

    @Override
    @OnError(value=SQLException.class)
    protected Object onErrorForAll(Method method, SQLException sQLException) throws SQLException {
        return super.onErrorForAll(method, sQLException);
    }

    @OnError(value=SQLException.class)
    @Methods(signatures={@Signature(name="last", args={})})
    protected boolean onErrorForLast(Method method, SQLException sQLException) throws SQLException {
        if (this.isClosedAndNoReplay) {
            throw sQLException;
        }
        TxnFailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        if (sQLException instanceof SQLRecoverableException && replayLifecycle == TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            this.failoverMngr.disableReplayInternal(method, 372, "Replay disabled because of nonreplayable call", null);
        }
        return (Boolean)super.onErrorForAll(method, sQLException);
    }

    @Override
    @GetDelegate
    protected abstract Object getDelegate();

    @Override
    @SetDelegate
    protected abstract void setDelegate(Object var1);

    @Override
    @GetCreator
    protected abstract Object getCreator();

    @Override
    public Object replayOneCall(TxnFailoverManagerImpl.CallHistoryEntry callHistoryEntry, SQLRecoverableException sQLRecoverableException) throws SQLException {
        Object object = super.replayOneCall(callHistoryEntry, sQLRecoverableException);
        return object;
    }
}

