/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.reflection;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;

public class TypeParameterResolver {
    public static Type resolveFieldType(Field field, Type srcType) {
        Type fieldType = field.getGenericType();
        Class<?> declaringClass = field.getDeclaringClass();
        return TypeParameterResolver.resolveType(fieldType, srcType, declaringClass);
    }

    public static Type resolveReturnType(Method method, Type srcType) {
        Type returnType = method.getGenericReturnType();
        Class<?> declaringClass = method.getDeclaringClass();
        return TypeParameterResolver.resolveType(returnType, srcType, declaringClass);
    }

    public static Type[] resolveParamTypes(Method method, Type srcType) {
        Type[] paramTypes = method.getGenericParameterTypes();
        Class<?> declaringClass = method.getDeclaringClass();
        Type[] result = new Type[paramTypes.length];
        for (int i2 = 0; i2 < paramTypes.length; ++i2) {
            result[i2] = TypeParameterResolver.resolveType(paramTypes[i2], srcType, declaringClass);
        }
        return result;
    }

    private static Type resolveType(Type type, Type srcType, Class<?> declaringClass) {
        if (type instanceof TypeVariable) {
            return TypeParameterResolver.resolveTypeVar((TypeVariable)type, srcType, declaringClass);
        }
        if (type instanceof ParameterizedType) {
            return TypeParameterResolver.resolveParameterizedType((ParameterizedType)type, srcType, declaringClass);
        }
        if (type instanceof GenericArrayType) {
            return TypeParameterResolver.resolveGenericArrayType((GenericArrayType)type, srcType, declaringClass);
        }
        return type;
    }

    private static Type resolveGenericArrayType(GenericArrayType genericArrayType, Type srcType, Class<?> declaringClass) {
        Type componentType = genericArrayType.getGenericComponentType();
        Type resolvedComponentType = null;
        if (componentType instanceof TypeVariable) {
            resolvedComponentType = TypeParameterResolver.resolveTypeVar((TypeVariable)componentType, srcType, declaringClass);
        } else if (componentType instanceof GenericArrayType) {
            resolvedComponentType = TypeParameterResolver.resolveGenericArrayType((GenericArrayType)componentType, srcType, declaringClass);
        } else if (componentType instanceof ParameterizedType) {
            resolvedComponentType = TypeParameterResolver.resolveParameterizedType((ParameterizedType)componentType, srcType, declaringClass);
        }
        if (resolvedComponentType instanceof Class) {
            return Array.newInstance((Class)resolvedComponentType, 0).getClass();
        }
        return new GenericArrayTypeImpl(resolvedComponentType);
    }

    private static ParameterizedType resolveParameterizedType(ParameterizedType parameterizedType, Type srcType, Class<?> declaringClass) {
        Class rawType = (Class)parameterizedType.getRawType();
        Type[] typeArgs = parameterizedType.getActualTypeArguments();
        Type[] args = new Type[typeArgs.length];
        for (int i2 = 0; i2 < typeArgs.length; ++i2) {
            args[i2] = typeArgs[i2] instanceof TypeVariable ? TypeParameterResolver.resolveTypeVar((TypeVariable)typeArgs[i2], srcType, declaringClass) : (typeArgs[i2] instanceof ParameterizedType ? TypeParameterResolver.resolveParameterizedType((ParameterizedType)typeArgs[i2], srcType, declaringClass) : (typeArgs[i2] instanceof WildcardType ? TypeParameterResolver.resolveWildcardType((WildcardType)typeArgs[i2], srcType, declaringClass) : typeArgs[i2]));
        }
        return new ParameterizedTypeImpl(rawType, null, args);
    }

    private static Type resolveWildcardType(WildcardType wildcardType, Type srcType, Class<?> declaringClass) {
        Type[] lowerBounds = TypeParameterResolver.resolveWildcardTypeBounds(wildcardType.getLowerBounds(), srcType, declaringClass);
        Type[] upperBounds = TypeParameterResolver.resolveWildcardTypeBounds(wildcardType.getUpperBounds(), srcType, declaringClass);
        return new WildcardTypeImpl(lowerBounds, upperBounds);
    }

    private static Type[] resolveWildcardTypeBounds(Type[] bounds, Type srcType, Class<?> declaringClass) {
        Type[] result = new Type[bounds.length];
        for (int i2 = 0; i2 < bounds.length; ++i2) {
            result[i2] = bounds[i2] instanceof TypeVariable ? TypeParameterResolver.resolveTypeVar((TypeVariable)bounds[i2], srcType, declaringClass) : (bounds[i2] instanceof ParameterizedType ? TypeParameterResolver.resolveParameterizedType((ParameterizedType)bounds[i2], srcType, declaringClass) : (bounds[i2] instanceof WildcardType ? TypeParameterResolver.resolveWildcardType((WildcardType)bounds[i2], srcType, declaringClass) : bounds[i2]));
        }
        return result;
    }

    private static Type resolveTypeVar(TypeVariable<?> typeVar, Type srcType, Class<?> declaringClass) {
        Type[] superInterfaces;
        Class clazz;
        if (srcType instanceof Class) {
            clazz = (Class)srcType;
        } else if (srcType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)srcType;
            clazz = (Class)parameterizedType.getRawType();
        } else {
            throw new IllegalArgumentException("The 2nd arg must be Class or ParameterizedType, but was: " + srcType.getClass());
        }
        if (clazz == declaringClass) {
            Type[] bounds = typeVar.getBounds();
            if (bounds.length > 0) {
                return bounds[0];
            }
            return Object.class;
        }
        Type superclass = clazz.getGenericSuperclass();
        Type result = TypeParameterResolver.scanSuperTypes(typeVar, srcType, declaringClass, clazz, superclass);
        if (result != null) {
            return result;
        }
        for (Type superInterface : superInterfaces = clazz.getGenericInterfaces()) {
            result = TypeParameterResolver.scanSuperTypes(typeVar, srcType, declaringClass, clazz, superInterface);
            if (result == null) continue;
            return result;
        }
        return Object.class;
    }

    private static Type scanSuperTypes(TypeVariable<?> typeVar, Type srcType, Class<?> declaringClass, Class<?> clazz, Type superclass) {
        if (superclass instanceof ParameterizedType) {
            ParameterizedType parentAsType = (ParameterizedType)superclass;
            Class parentAsClass = (Class)parentAsType.getRawType();
            TypeVariable<Class<T>>[] parentTypeVars = parentAsClass.getTypeParameters();
            if (srcType instanceof ParameterizedType) {
                parentAsType = TypeParameterResolver.translateParentTypeVars((ParameterizedType)srcType, clazz, parentAsType);
            }
            if (declaringClass == parentAsClass) {
                for (int i2 = 0; i2 < parentTypeVars.length; ++i2) {
                    if (!typeVar.equals(parentTypeVars[i2])) continue;
                    return parentAsType.getActualTypeArguments()[i2];
                }
            }
            if (declaringClass.isAssignableFrom(parentAsClass)) {
                return TypeParameterResolver.resolveTypeVar(typeVar, parentAsType, declaringClass);
            }
        } else if (superclass instanceof Class && declaringClass.isAssignableFrom((Class)superclass)) {
            return TypeParameterResolver.resolveTypeVar(typeVar, superclass, declaringClass);
        }
        return null;
    }

    private static ParameterizedType translateParentTypeVars(ParameterizedType srcType, Class<?> srcClass, ParameterizedType parentType) {
        Type[] parentTypeArgs = parentType.getActualTypeArguments();
        Type[] srcTypeArgs = srcType.getActualTypeArguments();
        TypeVariable<Class<?>>[] srcTypeVars = srcClass.getTypeParameters();
        Type[] newParentArgs = new Type[parentTypeArgs.length];
        boolean noChange = true;
        for (int i2 = 0; i2 < parentTypeArgs.length; ++i2) {
            if (parentTypeArgs[i2] instanceof TypeVariable) {
                for (int j2 = 0; j2 < srcTypeVars.length; ++j2) {
                    if (!srcTypeVars[j2].equals(parentTypeArgs[i2])) continue;
                    noChange = false;
                    newParentArgs[i2] = srcTypeArgs[j2];
                }
                continue;
            }
            newParentArgs[i2] = parentTypeArgs[i2];
        }
        return noChange ? parentType : new ParameterizedTypeImpl((Class)parentType.getRawType(), null, newParentArgs);
    }

    private TypeParameterResolver() {
    }

    static class GenericArrayTypeImpl
    implements GenericArrayType {
        private Type genericComponentType;

        GenericArrayTypeImpl(Type genericComponentType) {
            this.genericComponentType = genericComponentType;
        }

        @Override
        public Type getGenericComponentType() {
            return this.genericComponentType;
        }
    }

    static class WildcardTypeImpl
    implements WildcardType {
        private Type[] lowerBounds;
        private Type[] upperBounds;

        WildcardTypeImpl(Type[] lowerBounds, Type[] upperBounds) {
            this.lowerBounds = lowerBounds;
            this.upperBounds = upperBounds;
        }

        @Override
        public Type[] getLowerBounds() {
            return this.lowerBounds;
        }

        @Override
        public Type[] getUpperBounds() {
            return this.upperBounds;
        }
    }

    static class ParameterizedTypeImpl
    implements ParameterizedType {
        private Class<?> rawType;
        private Type ownerType;
        private Type[] actualTypeArguments;

        public ParameterizedTypeImpl(Class<?> rawType, Type ownerType, Type[] actualTypeArguments) {
            this.rawType = rawType;
            this.ownerType = ownerType;
            this.actualTypeArguments = actualTypeArguments;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return this.actualTypeArguments;
        }

        @Override
        public Type getOwnerType() {
            return this.ownerType;
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        public String toString() {
            return "ParameterizedTypeImpl [rawType=" + this.rawType + ", ownerType=" + this.ownerType + ", actualTypeArguments=" + Arrays.toString(this.actualTypeArguments) + "]";
        }
    }
}

