/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.plugins.inner;

import com.baomidou.mybatisplus.core.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.core.plugins.InterceptorIgnoreHelper;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.EncryptUtils;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.parser.JsqlParserSupport;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.update.Update;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;

public class IllegalSQLInnerInterceptor
extends JsqlParserSupport
implements InnerInterceptor {
    private static final Set<String> cacheValidResult = new HashSet<String>();
    private static final Map<String, List<IndexInfo>> indexInfoMap = new ConcurrentHashMap<String, List<IndexInfo>>();

    @Override
    public void beforePrepare(StatementHandler sh, Connection connection, Integer transactionTimeout) {
        PluginUtils.MPStatementHandler mpStatementHandler = PluginUtils.mpStatementHandler(sh);
        MappedStatement ms = mpStatementHandler.mappedStatement();
        SqlCommandType sct = ms.getSqlCommandType();
        if (sct == SqlCommandType.INSERT || InterceptorIgnoreHelper.willIgnoreIllegalSql(ms.getId())) {
            return;
        }
        BoundSql boundSql = mpStatementHandler.boundSql();
        String originalSql = boundSql.getSql();
        this.logger.debug("\u68c0\u67e5SQL\u662f\u5426\u5408\u89c4\uff0cSQL:" + originalSql);
        String md5Base64 = EncryptUtils.md5Base64(originalSql);
        if (cacheValidResult.contains(md5Base64)) {
            this.logger.debug("\u8be5SQL\u5df2\u9a8c\u8bc1\uff0c\u65e0\u9700\u518d\u6b21\u9a8c\u8bc1\uff0c\uff0cSQL:" + originalSql);
            return;
        }
        this.parserSingle(originalSql, connection);
        cacheValidResult.add(md5Base64);
    }

    @Override
    protected void processSelect(Select select, int index, String sql, Object obj) {
        SelectBody selectBody = select.getSelectBody();
        if (selectBody instanceof PlainSelect) {
            PlainSelect plainSelect = (PlainSelect)selectBody;
            Expression where = plainSelect.getWhere();
            Assert.notNull(where, "\u975e\u6cd5SQL\uff0c\u5fc5\u987b\u8981\u6709where\u6761\u4ef6", new Object[0]);
            Table table = (Table)plainSelect.getFromItem();
            List<Join> joins = plainSelect.getJoins();
            this.validWhere(where, table, (Connection)obj);
            this.validJoins(joins, table, (Connection)obj);
        }
    }

    @Override
    protected void processUpdate(Update update, int index, String sql, Object obj) {
        Expression where = update.getWhere();
        Assert.notNull(where, "\u975e\u6cd5SQL\uff0c\u5fc5\u987b\u8981\u6709where\u6761\u4ef6", new Object[0]);
        Table table = update.getTable();
        List<Join> joins = update.getJoins();
        this.validWhere(where, table, (Connection)obj);
        this.validJoins(joins, table, (Connection)obj);
    }

    @Override
    protected void processDelete(Delete delete, int index, String sql, Object obj) {
        Expression where = delete.getWhere();
        Assert.notNull(where, "\u975e\u6cd5SQL\uff0c\u5fc5\u987b\u8981\u6709where\u6761\u4ef6", new Object[0]);
        Table table = delete.getTable();
        List<Join> joins = delete.getJoins();
        this.validWhere(where, table, (Connection)obj);
        this.validJoins(joins, table, (Connection)obj);
    }

    private void validExpression(Expression expression) {
        InExpression inExpression;
        if (expression instanceof OrExpression) {
            OrExpression orExpression = (OrExpression)expression;
            throw new MybatisPlusException("\u975e\u6cd5SQL\uff0cwhere\u6761\u4ef6\u4e2d\u4e0d\u80fd\u4f7f\u7528\u3010or\u3011\u5173\u952e\u5b57\uff0c\u9519\u8befor\u4fe1\u606f\uff1a" + orExpression.toString());
        }
        if (expression instanceof NotEqualsTo) {
            NotEqualsTo notEqualsTo = (NotEqualsTo)expression;
            throw new MybatisPlusException("\u975e\u6cd5SQL\uff0cwhere\u6761\u4ef6\u4e2d\u4e0d\u80fd\u4f7f\u7528\u3010!=\u3011\u5173\u952e\u5b57\uff0c\u9519\u8bef!=\u4fe1\u606f\uff1a" + notEqualsTo.toString());
        }
        if (expression instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)expression;
            if (binaryExpression.getLeftExpression() instanceof Function) {
                Function function = (Function)binaryExpression.getLeftExpression();
                throw new MybatisPlusException("\u975e\u6cd5SQL\uff0cwhere\u6761\u4ef6\u4e2d\u4e0d\u80fd\u4f7f\u7528\u6570\u636e\u5e93\u51fd\u6570\uff0c\u9519\u8bef\u51fd\u6570\u4fe1\u606f\uff1a" + function.toString());
            }
            if (binaryExpression.getRightExpression() instanceof SubSelect) {
                SubSelect subSelect = (SubSelect)binaryExpression.getRightExpression();
                throw new MybatisPlusException("\u975e\u6cd5SQL\uff0cwhere\u6761\u4ef6\u4e2d\u4e0d\u80fd\u4f7f\u7528\u5b50\u67e5\u8be2\uff0c\u9519\u8bef\u5b50\u67e5\u8be2SQL\u4fe1\u606f\uff1a" + subSelect.toString());
            }
        } else if (expression instanceof InExpression && (inExpression = (InExpression)expression).getRightItemsList() instanceof SubSelect) {
            SubSelect subSelect = (SubSelect)inExpression.getRightItemsList();
            throw new MybatisPlusException("\u975e\u6cd5SQL\uff0cwhere\u6761\u4ef6\u4e2d\u4e0d\u80fd\u4f7f\u7528\u5b50\u67e5\u8be2\uff0c\u9519\u8bef\u5b50\u67e5\u8be2SQL\u4fe1\u606f\uff1a" + subSelect.toString());
        }
    }

    private void validJoins(List<Join> joins, Table table, Connection connection) {
        if (joins != null) {
            for (Join join : joins) {
                Table rightTable = (Table)join.getRightItem();
                Collection<Expression> onExpressions = join.getOnExpressions();
                for (Expression expression : onExpressions) {
                    this.validWhere(expression, table, rightTable, connection);
                }
            }
        }
    }

    private void validUseIndex(Table table, String columnName, Connection connection) {
        String tableName;
        boolean useIndexFlag = false;
        String tableInfo = table.getName();
        String dbName = null;
        String[] tableArray = tableInfo.split("\\.");
        if (tableArray.length == 1) {
            tableName = tableArray[0];
        } else {
            dbName = tableArray[0];
            tableName = tableArray[1];
        }
        List<IndexInfo> indexInfos = this.getIndexInfos(dbName, tableName, connection);
        for (IndexInfo indexInfo : indexInfos) {
            if (null == columnName || !columnName.equalsIgnoreCase(indexInfo.getColumnName())) continue;
            useIndexFlag = true;
            break;
        }
        if (!useIndexFlag) {
            throw new MybatisPlusException("\u975e\u6cd5SQL\uff0cSQL\u672a\u4f7f\u7528\u5230\u7d22\u5f15, table:" + table + ", columnName:" + columnName);
        }
    }

    private void validWhere(Expression expression, Table table, Connection connection) {
        this.validWhere(expression, table, null, connection);
    }

    private void validWhere(Expression expression, Table table, Table joinTable, Connection connection) {
        this.validExpression(expression);
        if (expression instanceof BinaryExpression) {
            Expression rightExpression;
            Expression leftExpression = ((BinaryExpression)expression).getLeftExpression();
            this.validExpression(leftExpression);
            if (leftExpression instanceof Column) {
                rightExpression = ((BinaryExpression)expression).getRightExpression();
                if (joinTable != null && rightExpression instanceof Column) {
                    if (Objects.equals(((Column)rightExpression).getTable().getName(), table.getAlias().getName())) {
                        this.validUseIndex(table, ((Column)rightExpression).getColumnName(), connection);
                        this.validUseIndex(joinTable, ((Column)leftExpression).getColumnName(), connection);
                    } else {
                        this.validUseIndex(joinTable, ((Column)rightExpression).getColumnName(), connection);
                        this.validUseIndex(table, ((Column)leftExpression).getColumnName(), connection);
                    }
                } else {
                    this.validUseIndex(table, ((Column)leftExpression).getColumnName(), connection);
                }
            } else if (leftExpression instanceof BinaryExpression) {
                this.validWhere(leftExpression, table, joinTable, connection);
            }
            rightExpression = ((BinaryExpression)expression).getRightExpression();
            this.validExpression(rightExpression);
        }
    }

    public List<IndexInfo> getIndexInfos(String dbName, String tableName, Connection conn) {
        return this.getIndexInfos(null, dbName, tableName, conn);
    }

    public List<IndexInfo> getIndexInfos(String key, String dbName, String tableName, Connection conn) {
        List<IndexInfo> indexInfos = null;
        if (StringUtils.isNotBlank(key)) {
            indexInfos = indexInfoMap.get(key);
        }
        if (indexInfos == null || indexInfos.isEmpty()) {
            try {
                DatabaseMetaData metadata = conn.getMetaData();
                String catalog = StringUtils.isBlank(dbName) ? conn.getCatalog() : dbName;
                String schema = StringUtils.isBlank(dbName) ? conn.getSchema() : dbName;
                ResultSet rs = metadata.getIndexInfo(catalog, schema, tableName, false, true);
                indexInfos = new ArrayList<IndexInfo>();
                while (rs.next()) {
                    if (!Objects.equals(rs.getString(8), "1")) continue;
                    IndexInfo indexInfo = new IndexInfo();
                    indexInfo.setDbName(rs.getString(1));
                    indexInfo.setTableName(rs.getString(3));
                    indexInfo.setColumnName(rs.getString(9));
                    indexInfos.add(indexInfo);
                }
                if (StringUtils.isNotBlank(key)) {
                    indexInfoMap.put(key, indexInfos);
                }
            }
            catch (SQLException e) {
                this.logger.error(String.format("getIndexInfo fault, with key:%s, dbName:%s, tableName:%s", key, dbName, tableName), e);
            }
        }
        return indexInfos;
    }

    private static class IndexInfo {
        private String dbName;
        private String tableName;
        private String columnName;

        public String getDbName() {
            return this.dbName;
        }

        public String getTableName() {
            return this.tableName;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public void setDbName(String dbName) {
            this.dbName = dbName;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IndexInfo)) {
                return false;
            }
            IndexInfo other = (IndexInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$dbName = this.getDbName();
            String other$dbName = other.getDbName();
            if (this$dbName == null ? other$dbName != null : !this$dbName.equals(other$dbName)) {
                return false;
            }
            String this$tableName = this.getTableName();
            String other$tableName = other.getTableName();
            if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
                return false;
            }
            String this$columnName = this.getColumnName();
            String other$columnName = other.getColumnName();
            return !(this$columnName == null ? other$columnName != null : !this$columnName.equals(other$columnName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof IndexInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $dbName = this.getDbName();
            result = result * 59 + ($dbName == null ? 43 : $dbName.hashCode());
            String $tableName = this.getTableName();
            result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
            String $columnName = this.getColumnName();
            result = result * 59 + ($columnName == null ? 43 : $columnName.hashCode());
            return result;
        }

        public String toString() {
            return "IllegalSQLInnerInterceptor.IndexInfo(dbName=" + this.getDbName() + ", tableName=" + this.getTableName() + ", columnName=" + this.getColumnName() + ")";
        }
    }
}

