/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.jdbc;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.ibatis.type.JdbcType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseMetaDataWrapper {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseMetaDataWrapper.class);
    private Connection connection;
    private final DatabaseMetaData databaseMetaData;
    private final String catalog;
    private final String schema;

    public DatabaseMetaDataWrapper(Connection connection, String schemaName) {
        try {
            if (null == connection) {
                throw new RuntimeException("\u6570\u636e\u5e93\u8fde\u63a5\u4e0d\u80fd\u4e3a\u7a7a");
            }
            this.connection = connection;
            this.databaseMetaData = connection.getMetaData();
            this.catalog = connection.getCatalog();
            this.schema = schemaName;
        }
        catch (SQLException e) {
            throw new RuntimeException("\u83b7\u53d6\u5143\u6570\u636e\u9519\u8bef:", e);
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void closeConnection() {
        Optional.ofNullable(this.connection).ifPresent(con -> {
            try {
                con.close();
            }
            catch (SQLException sqlException) {
                sqlException.printStackTrace();
            }
        });
    }

    public Map<String, Column> getColumnsInfo(String tableNamePattern, boolean queryPrimaryKey) {
        return this.getColumnsInfo(this.catalog, this.schema, tableNamePattern, queryPrimaryKey);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Column> getColumnsInfo(String catalog, String schema, String tableName, boolean queryPrimaryKey) {
        HashSet<String> primaryKeys = new HashSet<String>();
        if (queryPrimaryKey) {
            try (ResultSet primaryKeysResultSet = this.databaseMetaData.getPrimaryKeys(catalog, schema, tableName);){
                while (primaryKeysResultSet.next()) {
                    String columnName = primaryKeysResultSet.getString("COLUMN_NAME");
                    primaryKeys.add(columnName);
                }
                if (primaryKeys.size() > 1) {
                    logger.warn("\u5f53\u524d\u8868:{}\uff0c\u5b58\u5728\u591a\u4e3b\u952e\u60c5\u51b5\uff01", (Object)tableName);
                }
            }
            catch (SQLException e) {
                throw new RuntimeException("\u8bfb\u53d6\u8868\u4e3b\u952e\u4fe1\u606f:" + tableName + "\u9519\u8bef:", e);
            }
        }
        LinkedHashMap<String, Column> columnsInfoMap = new LinkedHashMap<String, Column>();
        try (ResultSet resultSet = this.databaseMetaData.getColumns(catalog, schema, tableName, "%");){
            while (resultSet.next()) {
                Column column = new Column();
                String name = resultSet.getString("COLUMN_NAME");
                column.name = name;
                column.primaryKey = primaryKeys.contains(name);
                column.jdbcType = JdbcType.forCode(resultSet.getInt("DATA_TYPE"));
                column.length = resultSet.getInt("COLUMN_SIZE");
                column.scale = resultSet.getInt("DECIMAL_DIGITS");
                column.remarks = this.formatComment(resultSet.getString("REMARKS"));
                column.defaultValue = resultSet.getString("COLUMN_DEF");
                column.nullable = resultSet.getInt("NULLABLE") == 1;
                try {
                    column.autoIncrement = "YES".equals(resultSet.getString("IS_AUTOINCREMENT"));
                }
                catch (SQLException sqlException) {
                    logger.warn("\u83b7\u53d6IS_AUTOINCREMENT\u51fa\u73b0\u5f02\u5e38:", (Throwable)sqlException);
                }
                columnsInfoMap.put(name.toLowerCase(), column);
            }
            Map<String, Column> map = Collections.unmodifiableMap(columnsInfoMap);
            return map;
        }
        catch (SQLException e) {
            throw new RuntimeException("\u8bfb\u53d6\u8868\u5b57\u6bb5\u4fe1\u606f:" + tableName + "\u9519\u8bef:", e);
        }
    }

    public String formatComment(String comment) {
        return StringUtils.isBlank(comment) ? "" : comment.replaceAll("\r\n", "\t");
    }

    public Table getTableInfo(String tableName) {
        return this.getTableInfo(this.catalog, this.schema, tableName);
    }

    public List<Table> getTables(String tableNamePattern, String[] types) {
        return this.getTables(this.catalog, this.schema, tableNamePattern, types);
    }

    public List<Table> getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) {
        ArrayList<Table> tables = new ArrayList<Table>();
        try (ResultSet resultSet = this.databaseMetaData.getTables(catalog, schemaPattern, tableNamePattern, types);){
            while (resultSet.next()) {
                Table table = new Table();
                table.name = resultSet.getString("TABLE_NAME");
                table.remarks = this.formatComment(resultSet.getString("REMARKS"));
                table.tableType = resultSet.getString("TABLE_TYPE");
                tables.add(table);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("\u8bfb\u53d6\u6570\u636e\u5e93\u8868\u4fe1\u606f\u51fa\u73b0\u9519\u8bef", e);
        }
        return tables;
    }

    public Table getTableInfo(String catalog, String schema, String tableName) {
        Table table = new Table();
        try (ResultSet resultSet = this.databaseMetaData.getTables(catalog, schema, tableName, new String[]{"TABLE", "VIEW"});){
            table.name = tableName;
            while (resultSet.next()) {
                table.remarks = this.formatComment(resultSet.getString("REMARKS"));
                table.tableType = resultSet.getString("TABLE_TYPE");
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("\u8bfb\u53d6\u8868\u4fe1\u606f:" + tableName + "\u9519\u8bef:", e);
        }
        return table;
    }

    public static class Column {
        private boolean primaryKey;
        private boolean autoIncrement;
        private String name;
        private int length;
        private boolean nullable;
        private String remarks;
        private String defaultValue;
        private int scale;
        private JdbcType jdbcType;

        public String getName() {
            return this.name;
        }

        public int getLength() {
            return this.length;
        }

        public boolean isNullable() {
            return this.nullable;
        }

        public String getRemarks() {
            return this.remarks;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public int getScale() {
            return this.scale;
        }

        public JdbcType getJdbcType() {
            return this.jdbcType;
        }

        public boolean isPrimaryKey() {
            return this.primaryKey;
        }

        public boolean isAutoIncrement() {
            return this.autoIncrement;
        }
    }

    public static class Table {
        private String name;
        private String remarks;
        private String tableType;

        public String getRemarks() {
            return this.remarks;
        }

        public String getTableType() {
            return this.tableType;
        }

        public String getName() {
            return this.name;
        }

        public boolean isView() {
            return "VIEW".equals(this.tableType);
        }
    }
}

