/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.plugins.inner;

import com.baomidou.mybatisplus.core.conditions.AbstractWrapper;
import com.baomidou.mybatisplus.core.conditions.ISqlSegment;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.segments.NormalSegmentList;
import com.baomidou.mybatisplus.core.conditions.update.Update;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.enums.SqlKeyword;
import com.baomidou.mybatisplus.core.mapper.Mapper;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.ReflectionKit;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;

public class OptimisticLockerInnerInterceptor
implements InnerInterceptor {
    private RuntimeException exception;
    private static final Map<String, Class<?>> ENTITY_CLASS_CACHE = new ConcurrentHashMap();
    private static final Pattern PARAM_PAIRS_RE = Pattern.compile("#\\{ew\\.paramNameValuePairs\\.(MPGENVAL\\d+)\\}");
    private static final String UPDATED_VERSION_VAL_KEY = "#updatedVersionVal#";
    private final boolean wrapperMode;

    public void setException(RuntimeException exception) {
        this.exception = exception;
    }

    public OptimisticLockerInnerInterceptor() {
        this(false);
    }

    public OptimisticLockerInnerInterceptor(boolean wrapperMode) {
        this.wrapperMode = wrapperMode;
    }

    @Override
    public void beforeUpdate(Executor executor, MappedStatement ms, Object parameter) throws SQLException {
        if (SqlCommandType.UPDATE != ms.getSqlCommandType()) {
            return;
        }
        if (parameter instanceof Map) {
            Map map = (Map)parameter;
            this.doOptimisticLocker(map, ms.getId());
        }
    }

    protected void doOptimisticLocker(Map<String, Object> map, String msId) {
        Object et = map.getOrDefault("et", null);
        if (Objects.nonNull(et)) {
            TableFieldInfo fieldInfo = this.getVersionFieldInfo(et.getClass());
            if (null == fieldInfo) {
                return;
            }
            try {
                Field versionField = fieldInfo.getField();
                Object originalVersionVal = versionField.get(et);
                if (originalVersionVal == null) {
                    if (null != this.exception) {
                        throw this.exception;
                    }
                    return;
                }
                String versionColumn = fieldInfo.getColumn();
                Object updatedVersionVal = this.getUpdatedVersionVal(fieldInfo.getPropertyType(), originalVersionVal);
                String methodName = msId.substring(msId.lastIndexOf(".") + 1);
                if ("update".equals(methodName)) {
                    AbstractWrapper aw = map.getOrDefault("ew", null);
                    if (aw == null) {
                        UpdateWrapper uw = new UpdateWrapper();
                        uw.eq(versionColumn, originalVersionVal);
                        map.put("ew", uw);
                    } else {
                        aw.apply(versionColumn + " = {0}", originalVersionVal);
                    }
                } else {
                    map.put("MP_OPTLOCK_VERSION_ORIGINAL", originalVersionVal);
                }
                versionField.set(et, updatedVersionVal);
            }
            catch (IllegalAccessException e) {
                throw ExceptionUtils.mpe(e);
            }
        } else if (this.wrapperMode && map.entrySet().stream().anyMatch(t -> Objects.equals(t.getKey(), "ew"))) {
            this.setVersionByWrapper(map, msId);
        }
    }

    protected TableFieldInfo getVersionFieldInfo(Class<?> entityClazz) {
        TableInfo tableInfo = TableInfoHelper.getTableInfo(entityClazz);
        return null != tableInfo && tableInfo.isWithVersion() ? tableInfo.getVersionFieldInfo() : null;
    }

    private void setVersionByWrapper(Map<String, Object> map, String msId) {
        Object ew = map.get("ew");
        if (ew instanceof AbstractWrapper && ew instanceof Update) {
            TableFieldInfo versionField;
            Class<?> entityClass = ENTITY_CLASS_CACHE.get(msId);
            if (null == entityClass) {
                try {
                    String className = msId.substring(0, msId.lastIndexOf(46));
                    entityClass = ReflectionKit.getSuperClassGenericType(Class.forName(className), Mapper.class, 0);
                    ENTITY_CLASS_CACHE.put(msId, entityClass);
                }
                catch (ClassNotFoundException e) {
                    throw ExceptionUtils.mpe(e);
                }
            }
            if (null == (versionField = this.getVersionFieldInfo(entityClass))) {
                return;
            }
            String versionColumn = versionField.getColumn();
            FieldEqFinder fieldEqFinder = new FieldEqFinder(versionColumn, (Wrapper)ew);
            if (!fieldEqFinder.isPresent()) {
                return;
            }
            Map<String, Object> paramNameValuePairs = ((AbstractWrapper)ew).getParamNameValuePairs();
            Object originalVersionValue = paramNameValuePairs.get(fieldEqFinder.valueKey);
            if (originalVersionValue == null) {
                return;
            }
            Object updatedVersionVal = this.getUpdatedVersionVal(originalVersionValue.getClass(), originalVersionValue);
            if (originalVersionValue == updatedVersionVal) {
                return;
            }
            paramNameValuePairs.put(UPDATED_VERSION_VAL_KEY, updatedVersionVal);
            ((Update)ew).setSql(String.format("%s = #{%s.%s}", versionColumn, "ew.paramNameValuePairs", UPDATED_VERSION_VAL_KEY));
        }
    }

    protected Object getUpdatedVersionVal(Class<?> clazz, Object originalVersionVal) {
        if (Long.TYPE.equals(clazz) || Long.class.equals(clazz)) {
            return (Long)originalVersionVal + 1L;
        }
        if (Integer.TYPE.equals(clazz) || Integer.class.equals(clazz)) {
            return (Integer)originalVersionVal + 1;
        }
        if (Date.class.equals(clazz)) {
            return new Date();
        }
        if (Timestamp.class.equals(clazz)) {
            return new Timestamp(System.currentTimeMillis());
        }
        if (LocalDateTime.class.equals(clazz)) {
            return LocalDateTime.now();
        }
        return originalVersionVal;
    }

    private static class FieldEqFinder {
        private String valueKey;
        private State state;
        private final String fieldName;

        public FieldEqFinder(String fieldName, Wrapper<?> wrapper) {
            this.fieldName = fieldName;
            this.state = State.INIT;
            this.find(wrapper);
        }

        public boolean isPresent() {
            return this.state == State.VERSION_VALUE_PRESENT;
        }

        private boolean find(Wrapper<?> wrapper) {
            NormalSegmentList segments = wrapper.getExpression().getNormal();
            for (ISqlSegment segment : segments) {
                Matcher matcher;
                if (this.state == State.FIELD_FOUND && segment == SqlKeyword.EQ) {
                    this.state = State.EQ_FOUND;
                    continue;
                }
                if (this.state == State.EQ_FOUND && (matcher = PARAM_PAIRS_RE.matcher(segment.getSqlSegment())).matches()) {
                    this.valueKey = matcher.group(1);
                    this.state = State.VERSION_VALUE_PRESENT;
                    return true;
                }
                if (segment instanceof Wrapper) {
                    if (!this.find((Wrapper)segment)) continue;
                    return true;
                }
                if (!segment.getSqlSegment().equals(this.fieldName)) continue;
                this.state = State.FIELD_FOUND;
            }
            return false;
        }

        static enum State {
            INIT,
            FIELD_FOUND,
            EQ_FOUND,
            VERSION_VALUE_PRESENT;

        }
    }
}

