/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db.nosql.mongo;

import cn.hutool.core.exceptions.NotInitedException;
import cn.hutool.core.net.NetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.DbRuntimeException;
import cn.hutool.log.Log;
import cn.hutool.setting.Setting;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.connection.ConnectionPoolSettings;
import com.mongodb.connection.SocketSettings;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.bson.Document;

public class MongoDS
implements Closeable {
    private static final Log log = Log.get();
    public static final String MONGO_CONFIG_PATH = "config/mongo.setting";
    private Setting setting;
    private String[] groups;
    private ServerAddress serverAddress;
    private MongoClient mongo;

    public MongoDS(String host, int port) {
        this.serverAddress = this.createServerAddress(host, port);
        this.initSingle();
    }

    public MongoDS(Setting mongoSetting, String host, int port) {
        this.setting = mongoSetting;
        this.serverAddress = this.createServerAddress(host, port);
        this.initSingle();
    }

    public MongoDS(String ... groups) {
        this.groups = groups;
        this.init();
    }

    public MongoDS(Setting mongoSetting, String ... groups) {
        if (mongoSetting == null) {
            throw new DbRuntimeException("Mongo setting is null!");
        }
        this.setting = mongoSetting;
        this.groups = groups;
        this.init();
    }

    public void init() {
        if (this.groups != null && this.groups.length > 1) {
            this.initCloud();
        } else {
            this.initSingle();
        }
    }

    public synchronized void initSingle() {
        if (this.setting == null) {
            try {
                this.setting = new Setting(MONGO_CONFIG_PATH, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String group = "";
        if (null == this.serverAddress) {
            if (this.groups != null && this.groups.length == 1) {
                group = this.groups[0];
            }
            this.serverAddress = this.createServerAddress(group);
        }
        MongoCredential credentail = this.createCredentail(group);
        try {
            MongoClientSettings.Builder clusterSettingsBuilder = MongoClientSettings.builder().applyToClusterSettings(b2 -> b2.hosts(Collections.singletonList(this.serverAddress)));
            this.buildMongoClientSettings(clusterSettingsBuilder, group);
            if (null != credentail) {
                clusterSettingsBuilder.credential(credentail);
            }
            this.mongo = MongoClients.create((MongoClientSettings)clusterSettingsBuilder.build());
        }
        catch (Exception e2) {
            throw new DbRuntimeException(StrUtil.format("Init MongoDB pool with connection to [{}] error!", this.serverAddress), e2);
        }
        log.info("Init MongoDB pool with connection to [{}]", this.serverAddress);
    }

    public synchronized void initCloud() {
        if (this.groups == null || this.groups.length == 0) {
            throw new DbRuntimeException("Please give replication set groups!");
        }
        if (this.setting == null) {
            this.setting = new Setting(MONGO_CONFIG_PATH, true);
        }
        ArrayList<ServerAddress> addrList = new ArrayList<ServerAddress>();
        for (String group : this.groups) {
            addrList.add(this.createServerAddress(group));
        }
        MongoCredential credentail = this.createCredentail("");
        try {
            MongoClientSettings.Builder clusterSettingsBuilder = MongoClientSettings.builder().applyToClusterSettings(b2 -> b2.hosts(addrList));
            this.buildMongoClientSettings(clusterSettingsBuilder, "");
            if (null != credentail) {
                clusterSettingsBuilder.credential(credentail);
            }
            this.mongo = MongoClients.create((MongoClientSettings)clusterSettingsBuilder.build());
        }
        catch (Exception e2) {
            log.error(e2, "Init MongoDB connection error!", new Object[0]);
            return;
        }
        log.info("Init MongoDB cloud Set pool with connection to {}", addrList);
    }

    public void setSetting(Setting setting) {
        this.setting = setting;
    }

    public MongoClient getMongo() {
        return this.mongo;
    }

    public MongoDatabase getDb(String dbName) {
        return this.mongo.getDatabase(dbName);
    }

    public MongoCollection<Document> getCollection(String dbName, String collectionName) {
        return this.getDb(dbName).getCollection(collectionName);
    }

    @Override
    public void close() {
        this.mongo.close();
    }

    private ServerAddress createServerAddress(String group) {
        String tmpHost;
        Setting setting = this.checkSetting();
        if (group == null) {
            group = "";
        }
        if (StrUtil.isBlank(tmpHost = setting.getByGroup("host", group))) {
            throw new NotInitedException("Host name is empy of group: {}", group);
        }
        int defaultPort = setting.getInt("port", group, 27017);
        return new ServerAddress(NetUtil.buildInetSocketAddress(tmpHost, defaultPort));
    }

    private ServerAddress createServerAddress(String host, int port) {
        return new ServerAddress(host, port);
    }

    private MongoCredential createCredentail(String group) {
        Setting setting = this.setting;
        if (null == setting) {
            return null;
        }
        String user = setting.getStr("user", group, setting.getStr("user"));
        String pass = setting.getStr("pass", group, setting.getStr("pass"));
        String database = setting.getStr("database", group, setting.getStr("database"));
        return this.createCredentail(user, database, pass);
    }

    private MongoCredential createCredentail(String userName, String database, String password) {
        if (StrUtil.hasEmpty(userName, database, database)) {
            return null;
        }
        return MongoCredential.createCredential((String)userName, (String)database, (char[])password.toCharArray());
    }

    private MongoClientSettings.Builder buildMongoClientSettings(MongoClientSettings.Builder builder, String group) {
        if (this.setting == null) {
            return builder;
        }
        group = StrUtil.isEmpty(group) ? "" : group + ".";
        Integer connectionsPerHost = this.setting.getInt(group + "connectionsPerHost");
        if (!StrUtil.isBlank(group) && connectionsPerHost == null) {
            connectionsPerHost = this.setting.getInt("connectionsPerHost");
        }
        ConnectionPoolSettings.Builder connectionPoolSettingsBuilder = ConnectionPoolSettings.builder();
        if (connectionsPerHost != null) {
            connectionPoolSettingsBuilder.maxSize(connectionsPerHost.intValue());
            log.debug("MongoDB connectionsPerHost: {}", connectionsPerHost);
        }
        Integer connectTimeout = this.setting.getInt(group + "connectTimeout");
        if (!StrUtil.isBlank(group) && connectTimeout == null) {
            this.setting.getInt("connectTimeout");
        }
        if (connectTimeout != null) {
            connectionPoolSettingsBuilder.maxWaitTime((long)connectTimeout.intValue(), TimeUnit.MILLISECONDS);
            log.debug("MongoDB connectTimeout: {}", connectTimeout);
        }
        builder.applyToConnectionPoolSettings(b2 -> b2.applySettings(connectionPoolSettingsBuilder.build()));
        Integer socketTimeout = this.setting.getInt(group + "socketTimeout");
        if (!StrUtil.isBlank(group) && socketTimeout == null) {
            this.setting.getInt("socketTimeout");
        }
        if (socketTimeout != null) {
            SocketSettings socketSettings = SocketSettings.builder().connectTimeout(socketTimeout.intValue(), TimeUnit.MILLISECONDS).build();
            builder.applyToSocketSettings(b2 -> b2.applySettings(socketSettings));
            log.debug("MongoDB socketTimeout: {}", socketTimeout);
        }
        return builder;
    }

    private Setting checkSetting() {
        if (null == this.setting) {
            throw new DbRuntimeException("Please indicate setting file or create default [{}]", MONGO_CONFIG_PATH);
        }
        return this.setting;
    }
}

