/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.handlers;

import com.baomidou.mybatisplus.core.handlers.MybatisEnumTypeHandler;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import java.lang.reflect.Constructor;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.type.EnumTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeException;
import org.apache.ibatis.type.TypeHandler;

public class CompositeEnumTypeHandler<E extends Enum<E>>
implements TypeHandler<E> {
    private static final Map<Class<?>, Boolean> MP_ENUM_CACHE = new ConcurrentHashMap();
    private static Class<? extends TypeHandler> defaultEnumTypeHandler = EnumTypeHandler.class;
    private final TypeHandler<E> delegate;

    public CompositeEnumTypeHandler(Class<E> enumClassType) {
        if (enumClassType == null) {
            throw new IllegalArgumentException("Type argument cannot be null");
        }
        this.delegate = CollectionUtils.computeIfAbsent(MP_ENUM_CACHE, enumClassType, MybatisEnumTypeHandler::isMpEnums) != false ? new MybatisEnumTypeHandler<E>(enumClassType) : this.getInstance(enumClassType, defaultEnumTypeHandler);
    }

    @Override
    public void setParameter(PreparedStatement ps, int i2, E parameter, JdbcType jdbcType) throws SQLException {
        this.delegate.setParameter(ps, i2, parameter, jdbcType);
    }

    @Override
    public E getResult(ResultSet rs, String columnName) throws SQLException {
        return (E)((Enum)this.delegate.getResult(rs, columnName));
    }

    @Override
    public E getResult(ResultSet rs, int columnIndex) throws SQLException {
        return (E)((Enum)this.delegate.getResult(rs, columnIndex));
    }

    @Override
    public E getResult(CallableStatement cs, int columnIndex) throws SQLException {
        return (E)((Enum)this.delegate.getResult(cs, columnIndex));
    }

    public <T> TypeHandler<T> getInstance(Class<?> javaTypeClass, Class<?> typeHandlerClass) {
        if (javaTypeClass != null) {
            try {
                Constructor<?> c2 = typeHandlerClass.getConstructor(Class.class);
                return (TypeHandler)c2.newInstance(javaTypeClass);
            }
            catch (NoSuchMethodException c2) {
            }
            catch (Exception e2) {
                throw new TypeException("Failed invoking constructor for handler " + typeHandlerClass, e2);
            }
        }
        try {
            Constructor<?> c3 = typeHandlerClass.getConstructor(new Class[0]);
            return (TypeHandler)c3.newInstance(new Object[0]);
        }
        catch (Exception e3) {
            throw new TypeException("Unable to find a usable constructor for " + typeHandlerClass, e3);
        }
    }

    public static void setDefaultEnumTypeHandler(Class<? extends TypeHandler> defaultEnumTypeHandler) {
        CompositeEnumTypeHandler.defaultEnumTypeHandler = defaultEnumTypeHandler;
    }
}

