/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.toolkit.sql;

public class StringEscape {
    private static boolean isEscapeNeededForString(String str, int len) {
        boolean needsHexEscape = false;
        for (int i2 = 0; i2 < len; ++i2) {
            char c2 = str.charAt(i2);
            switch (c2) {
                case '\u0000': {
                    needsHexEscape = true;
                    break;
                }
                case '\n': {
                    needsHexEscape = true;
                    break;
                }
                case '\r': {
                    needsHexEscape = true;
                    break;
                }
                case '\\': {
                    needsHexEscape = true;
                    break;
                }
                case '\'': {
                    needsHexEscape = true;
                    break;
                }
                case '\"': {
                    needsHexEscape = true;
                    break;
                }
                case '\u001a': {
                    needsHexEscape = true;
                    break;
                }
            }
            if (needsHexEscape) break;
        }
        return needsHexEscape;
    }

    public static String escapeRawString(String escapeStr) {
        int stringLength = escapeStr.length();
        if (StringEscape.isEscapeNeededForString(escapeStr, stringLength)) {
            StringBuilder buf = new StringBuilder((int)((double)escapeStr.length() * 1.1));
            block9: for (int i2 = 0; i2 < stringLength; ++i2) {
                char c2 = escapeStr.charAt(i2);
                switch (c2) {
                    case '\u0000': {
                        buf.append('\\');
                        buf.append('0');
                        continue block9;
                    }
                    case '\n': {
                        buf.append('\\');
                        buf.append('n');
                        continue block9;
                    }
                    case '\r': {
                        buf.append('\\');
                        buf.append('r');
                        continue block9;
                    }
                    case '\\': {
                        buf.append('\\');
                        buf.append('\\');
                        continue block9;
                    }
                    case '\'': {
                        buf.append('\\');
                        buf.append('\'');
                        continue block9;
                    }
                    case '\"': {
                        buf.append('\\');
                        buf.append('\"');
                        continue block9;
                    }
                    case '\u001a': {
                        buf.append('\\');
                        buf.append('Z');
                        continue block9;
                    }
                    default: {
                        buf.append(c2);
                    }
                }
            }
            return buf.toString();
        }
        return escapeStr;
    }

    public static String escapeString(String escapeStr) {
        if (escapeStr.matches("'(.+)'")) {
            escapeStr = escapeStr.substring(1, escapeStr.length() - 1);
        }
        return "'" + StringEscape.escapeRawString(escapeStr) + "'";
    }
}

