/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.protocol;

import com.mysql.cj.Messages;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FullReadInputStream
extends FilterInputStream {
    public FullReadInputStream(InputStream underlyingStream) {
        super(underlyingStream);
    }

    public InputStream getUnderlyingStream() {
        return this.in;
    }

    public int readFully(byte[] b2) throws IOException {
        return this.readFully(b2, 0, b2.length);
    }

    public int readFully(byte[] b2, int off, int len) throws IOException {
        int n2;
        int count;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (n2 = 0; n2 < len; n2 += count) {
            count = this.read(b2, off + n2, len - n2);
            if (count >= 0) continue;
            throw new EOFException(Messages.getString("MysqlIO.EOF", new Object[]{len, n2}));
        }
        return n2;
    }

    public long skipFully(long len) throws IOException {
        long n2;
        long count;
        if (len < 0L) {
            throw new IOException(Messages.getString("MysqlIO.105"));
        }
        for (n2 = 0L; n2 < len; n2 += count) {
            count = this.skip(len - n2);
            if (count >= 0L) continue;
            throw new EOFException(Messages.getString("MysqlIO.EOF", new Object[]{len, n2}));
        }
        return n2;
    }

    public int skipLengthEncodedInteger() throws IOException {
        int sw = this.read() & 0xFF;
        switch (sw) {
            case 252: {
                return (int)this.skipFully(2L) + 1;
            }
            case 253: {
                return (int)this.skipFully(3L) + 1;
            }
            case 254: {
                return (int)this.skipFully(8L) + 1;
            }
        }
        return 1;
    }
}

