/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.deparser;

import java.util.Iterator;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.ItemsListVisitor;
import net.sf.jsqlparser.expression.operators.relational.MultiExpressionList;
import net.sf.jsqlparser.expression.operators.relational.NamedExpressionList;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.replace.Replace;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.util.deparser.AbstractDeParser;

public class ReplaceDeParser
extends AbstractDeParser<Replace>
implements ItemsListVisitor {
    private ExpressionVisitor expressionVisitor;
    private SelectVisitor selectVisitor;

    public ReplaceDeParser() {
        super(new StringBuilder());
    }

    public ReplaceDeParser(ExpressionVisitor expressionVisitor, SelectVisitor selectVisitor, StringBuilder buffer) {
        super(buffer);
        this.expressionVisitor = expressionVisitor;
        this.selectVisitor = selectVisitor;
    }

    @Override
    public void deParse(Replace replace) {
        this.buffer.append("REPLACE ");
        if (replace.isUseIntoTables()) {
            this.buffer.append("INTO ");
        }
        this.buffer.append(replace.getTable().getFullyQualifiedName());
        if (replace.getItemsList() != null) {
            if (replace.getColumns() != null) {
                this.buffer.append(" (");
                for (int i2 = 0; i2 < replace.getColumns().size(); ++i2) {
                    Column column = replace.getColumns().get(i2);
                    this.buffer.append(column.getFullyQualifiedName());
                    if (i2 >= replace.getColumns().size() - 1) continue;
                    this.buffer.append(", ");
                }
                this.buffer.append(") ");
            } else {
                this.buffer.append(" ");
            }
        } else {
            this.buffer.append(" SET ");
            for (int i3 = 0; i3 < replace.getColumns().size(); ++i3) {
                Column column = replace.getColumns().get(i3);
                this.buffer.append(column.getFullyQualifiedName()).append("=");
                Expression expression = replace.getExpressions().get(i3);
                expression.accept(this.expressionVisitor);
                if (i3 >= replace.getColumns().size() - 1) continue;
                this.buffer.append(", ");
            }
        }
        if (replace.getItemsList() != null) {
            replace.getItemsList().accept(this);
        }
    }

    @Override
    public void visit(ExpressionList expressionList) {
        this.buffer.append("VALUES (");
        Iterator<Expression> iter = expressionList.getExpressions().iterator();
        while (iter.hasNext()) {
            Expression expression = iter.next();
            expression.accept(this.expressionVisitor);
            if (!iter.hasNext()) continue;
            this.buffer.append(", ");
        }
        this.buffer.append(")");
    }

    @Override
    public void visit(NamedExpressionList namedExpressionList) {
    }

    @Override
    public void visit(SubSelect subSelect) {
        subSelect.getSelectBody().accept(this.selectVisitor);
    }

    public ExpressionVisitor getExpressionVisitor() {
        return this.expressionVisitor;
    }

    public SelectVisitor getSelectVisitor() {
        return this.selectVisitor;
    }

    public void setExpressionVisitor(ExpressionVisitor visitor) {
        this.expressionVisitor = visitor;
    }

    public void setSelectVisitor(SelectVisitor visitor) {
        this.selectVisitor = visitor;
    }

    @Override
    public void visit(MultiExpressionList multiExprList) {
        this.buffer.append("VALUES ");
        Iterator<ExpressionList> it = multiExprList.getExprList().iterator();
        while (it.hasNext()) {
            this.buffer.append("(");
            Iterator<Expression> iter = it.next().getExpressions().iterator();
            while (iter.hasNext()) {
                Expression expression = iter.next();
                expression.accept(this.expressionVisitor);
                if (!iter.hasNext()) continue;
                this.buffer.append(", ");
            }
            this.buffer.append(")");
            if (!it.hasNext()) continue;
            this.buffer.append(", ");
        }
    }
}

