/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.validation;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.sf.jsqlparser.parser.feature.Feature;
import net.sf.jsqlparser.parser.feature.FeatureConfiguration;
import net.sf.jsqlparser.util.validation.ContextKey;
import net.sf.jsqlparser.util.validation.ValidationCapability;

public class ValidationContext {
    private Collection<ValidationCapability> capabilities;
    private FeatureConfiguration configuration = new FeatureConfiguration();
    private Map<ContextKey, Object> contextMap = new HashMap<ContextKey, Object>();

    public ValidationContext put(ContextKey key, Object value) {
        this.contextMap.put(key, value);
        return this;
    }

    public <T> T get(ContextKey key, Class<T> type) {
        T t2 = this.getOptional(key, type);
        if (t2 == null) {
            throw new IllegalStateException(key + ": value missing");
        }
        return t2;
    }

    public <T> T getOptional(ContextKey key, Class<T> type) {
        return type.cast(this.contextMap.get(key));
    }

    public ValidationContext reinit(boolean reInit) {
        if (reInit) {
            this.contextMap.clear();
        }
        return this;
    }

    public ValidationContext setConfiguration(FeatureConfiguration configuration) {
        this.configuration = configuration;
        return this;
    }

    public FeatureConfiguration getConfiguration() {
        return this.configuration;
    }

    public boolean getAsBoolean(Feature f2) {
        return this.getConfiguration().getAsBoolean(f2);
    }

    public String getAsString(Feature f2) {
        return this.getConfiguration().getAsString(f2);
    }

    public Collection<ValidationCapability> getCapabilities() {
        return this.capabilities;
    }

    public ValidationContext setCapabilities(Collection<ValidationCapability> capabilities) {
        this.capabilities = capabilities;
        return this;
    }
}

