/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.ognl;

import org.apache.ibatis.ognl.ASTChain;
import org.apache.ibatis.ognl.ASTMethod;
import org.apache.ibatis.ognl.ASTProperty;
import org.apache.ibatis.ognl.ASTSequence;
import org.apache.ibatis.ognl.NumericExpression;
import org.apache.ibatis.ognl.OgnlContext;
import org.apache.ibatis.ognl.OgnlException;
import org.apache.ibatis.ognl.OgnlParser;
import org.apache.ibatis.ognl.OgnlParserTreeConstants;
import org.apache.ibatis.ognl.SimpleNode;
import org.apache.ibatis.ognl.enhance.ExpressionCompiler;

public abstract class ExpressionNode
extends SimpleNode {
    public ExpressionNode(int i2) {
        super(i2);
    }

    public ExpressionNode(OgnlParser p2, int i2) {
        super(p2, i2);
    }

    @Override
    public boolean isNodeConstant(OgnlContext context) throws OgnlException {
        return false;
    }

    @Override
    public boolean isConstant(OgnlContext context) throws OgnlException {
        boolean result = this.isNodeConstant(context);
        if (this._children != null && this._children.length > 0) {
            result = true;
            for (int i2 = 0; result && i2 < this._children.length; ++i2) {
                result = this._children[i2] instanceof SimpleNode ? ((SimpleNode)this._children[i2]).isConstant(context) : false;
            }
        }
        return result;
    }

    public String getExpressionOperator(int index) {
        throw new RuntimeException("unknown operator for " + OgnlParserTreeConstants.jjtNodeName[this._id]);
    }

    @Override
    public String toString() {
        String result;
        String string = result = this._parent == null ? "" : "(";
        if (this._children != null && this._children.length > 0) {
            for (int i2 = 0; i2 < this._children.length; ++i2) {
                if (i2 > 0) {
                    result = result + " " + this.getExpressionOperator(i2) + " ";
                }
                result = result + this._children[i2].toString();
            }
        }
        if (this._parent != null) {
            result = result + ")";
        }
        return result;
    }

    @Override
    public String toGetSourceString(OgnlContext context, Object target) {
        String result;
        String string = result = this._parent == null || NumericExpression.class.isAssignableFrom(this._parent.getClass()) ? "" : "(";
        if (this._children != null && this._children.length > 0) {
            for (int i2 = 0; i2 < this._children.length; ++i2) {
                if (i2 > 0) {
                    result = result + " " + this.getExpressionOperator(i2) + " ";
                }
                String value = this._children[i2].toGetSourceString(context, target);
                if ((ASTProperty.class.isInstance(this._children[i2]) || ASTMethod.class.isInstance(this._children[i2]) || ASTSequence.class.isInstance(this._children[i2]) || ASTChain.class.isInstance(this._children[i2])) && value != null && value.trim().length() > 0) {
                    String cast;
                    String pre = null;
                    if (ASTMethod.class.isInstance(this._children[i2])) {
                        pre = (String)context.get("_currentChain");
                    }
                    if (pre == null) {
                        pre = "";
                    }
                    if ((cast = (String)context.remove("_preCast")) == null) {
                        cast = "";
                    }
                    value = cast + ExpressionCompiler.getRootExpression(this._children[i2], context.getRoot(), context) + pre + value;
                }
                result = result + value;
            }
        }
        if (this._parent != null && !NumericExpression.class.isAssignableFrom(this._parent.getClass())) {
            result = result + ")";
        }
        return result;
    }

    @Override
    public String toSetSourceString(OgnlContext context, Object target) {
        String result;
        String string = result = this._parent == null ? "" : "(";
        if (this._children != null && this._children.length > 0) {
            for (int i2 = 0; i2 < this._children.length; ++i2) {
                if (i2 > 0) {
                    result = result + " " + this.getExpressionOperator(i2) + " ";
                }
                result = result + this._children[i2].toSetSourceString(context, target);
            }
        }
        if (this._parent != null) {
            result = result + ")";
        }
        return result;
    }

    @Override
    public boolean isOperation(OgnlContext context) throws OgnlException {
        return true;
    }
}

