/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.plugins.inner;

import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.plugins.InterceptorIgnoreHelper;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.parser.JsqlParserSupport;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import java.sql.Connection;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.sf.jsqlparser.parser.ASTNodeAccessImpl;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.update.Update;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;

public class BlockAttackInnerInterceptor
extends JsqlParserSupport
implements InnerInterceptor {
    @Override
    public void beforePrepare(StatementHandler sh, Connection connection, Integer transactionTimeout) {
        PluginUtils.MPStatementHandler handler = PluginUtils.mpStatementHandler(sh);
        MappedStatement ms = handler.mappedStatement();
        SqlCommandType sct = ms.getSqlCommandType();
        if (sct == SqlCommandType.UPDATE || sct == SqlCommandType.DELETE) {
            if (InterceptorIgnoreHelper.willIgnoreBlockAttack(ms.getId())) {
                return;
            }
            BoundSql boundSql = handler.boundSql();
            this.parserMulti(boundSql.getSql(), null);
        }
    }

    @Override
    protected void processDelete(Delete delete, int index, String sql, Object obj) {
        this.checkWhere(delete.getTable().getName(), delete.getWhere(), "Prohibition of full table deletion");
    }

    @Override
    protected void processUpdate(Update update, int index, String sql, Object obj) {
        this.checkWhere(update.getTable().getName(), update.getWhere(), "Prohibition of table update operation");
    }

    protected void checkWhere(String tableName, Expression where, String ex) {
        Assert.isFalse(this.fullMatch(where, this.getTableLogicField(tableName)), ex, new Object[0]);
    }

    private boolean fullMatch(Expression where, String logicField) {
        if (where == null) {
            return true;
        }
        if (StringUtils.isNotBlank(logicField)) {
            ASTNodeAccessImpl binaryExpression;
            if (where instanceof BinaryExpression && (StringUtils.equals(((BinaryExpression)(binaryExpression = (BinaryExpression)where)).getLeftExpression().toString(), logicField) || StringUtils.equals(((BinaryExpression)binaryExpression).getRightExpression().toString(), logicField))) {
                return true;
            }
            if (where instanceof IsNullExpression && StringUtils.equals(((IsNullExpression)(binaryExpression = (IsNullExpression)where)).getLeftExpression().toString(), logicField)) {
                return true;
            }
        }
        if (where instanceof EqualsTo) {
            EqualsTo equalsTo = (EqualsTo)where;
            return StringUtils.equals(equalsTo.getLeftExpression().toString(), equalsTo.getRightExpression().toString());
        }
        if (where instanceof NotEqualsTo) {
            NotEqualsTo notEqualsTo = (NotEqualsTo)where;
            return !StringUtils.equals(notEqualsTo.getLeftExpression().toString(), notEqualsTo.getRightExpression().toString());
        }
        if (where instanceof OrExpression) {
            OrExpression orExpression = (OrExpression)where;
            return this.fullMatch(orExpression.getLeftExpression(), logicField) || this.fullMatch(orExpression.getRightExpression(), logicField);
        }
        if (where instanceof AndExpression) {
            AndExpression andExpression = (AndExpression)where;
            return this.fullMatch(andExpression.getLeftExpression(), logicField) && this.fullMatch(andExpression.getRightExpression(), logicField);
        }
        if (where instanceof Parenthesis) {
            Parenthesis parenthesis = (Parenthesis)where;
            return this.fullMatch(parenthesis.getExpression(), logicField);
        }
        return false;
    }

    private String getTableLogicField(String tableName) {
        if (StringUtils.isBlank(tableName)) {
            return "";
        }
        TableInfo tableInfo = TableInfoHelper.getTableInfo(tableName);
        if (tableInfo == null || !tableInfo.isWithLogicDelete() || tableInfo.getLogicDeleteFieldInfo() == null) {
            return "";
        }
        return tableInfo.getLogicDeleteFieldInfo().getColumn();
    }
}

