/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.activerecord;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.enums.SqlMethod;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.GlobalConfigUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import com.baomidou.mybatisplus.extension.toolkit.SqlRunner;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.session.SqlSession;
import org.mybatis.spring.SqlSessionUtils;

public abstract class Model<T extends Model<?>>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final transient Class<?> entityClass = this.getClass();

    public boolean insert() {
        SqlSession sqlSession = this.sqlSession();
        try {
            boolean bl = SqlHelper.retBool(sqlSession.insert(this.sqlStatement(SqlMethod.INSERT_ONE), this));
            return bl;
        }
        finally {
            this.closeSqlSession(sqlSession);
        }
    }

    public boolean insertOrUpdate() {
        return StringUtils.checkValNull(this.pkVal()) || Objects.isNull(this.selectById(this.pkVal())) ? this.insert() : this.updateById();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteById(Serializable id) {
        SqlSession sqlSession = this.sqlSession();
        try {
            boolean bl = SqlHelper.retBool(sqlSession.delete(this.sqlStatement(SqlMethod.DELETE_BY_ID), id));
            return bl;
        }
        finally {
            this.closeSqlSession(sqlSession);
        }
    }

    public boolean deleteById() {
        Assert.isFalse(StringUtils.checkValNull(this.pkVal()), "deleteById primaryKey is null.", new Object[0]);
        return this.deleteById(this.pkVal());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(Wrapper<T> queryWrapper) {
        HashMap<String, Wrapper<T>> map = CollectionUtils.newHashMapWithExpectedSize(1);
        map.put("ew", queryWrapper);
        SqlSession sqlSession = this.sqlSession();
        try {
            boolean bl = SqlHelper.retBool(sqlSession.delete(this.sqlStatement(SqlMethod.DELETE), map));
            return bl;
        }
        finally {
            this.closeSqlSession(sqlSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateById() {
        Assert.isFalse(StringUtils.checkValNull(this.pkVal()), "updateById primaryKey is null.", new Object[0]);
        HashMap<String, Model> map = CollectionUtils.newHashMapWithExpectedSize(1);
        map.put("et", this);
        SqlSession sqlSession = this.sqlSession();
        try {
            boolean bl = SqlHelper.retBool(sqlSession.update(this.sqlStatement(SqlMethod.UPDATE_BY_ID), map));
            return bl;
        }
        finally {
            this.closeSqlSession(sqlSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update(Wrapper<T> updateWrapper) {
        HashMap<String, Serializable> map = CollectionUtils.newHashMapWithExpectedSize(2);
        map.put("et", this);
        map.put("ew", updateWrapper);
        SqlSession sqlSession = this.sqlSession();
        try {
            boolean bl = SqlHelper.retBool(sqlSession.update(this.sqlStatement(SqlMethod.UPDATE), map));
            return bl;
        }
        finally {
            this.closeSqlSession(sqlSession);
        }
    }

    public List<T> selectAll() {
        SqlSession sqlSession = this.sqlSession();
        try {
            List list = sqlSession.selectList(this.sqlStatement(SqlMethod.SELECT_LIST));
            return list;
        }
        finally {
            this.closeSqlSession(sqlSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T selectById(Serializable id) {
        SqlSession sqlSession = this.sqlSession();
        try {
            Model model = (Model)sqlSession.selectOne(this.sqlStatement(SqlMethod.SELECT_BY_ID), id);
            return (T)model;
        }
        finally {
            this.closeSqlSession(sqlSession);
        }
    }

    public T selectById() {
        Assert.isFalse(StringUtils.checkValNull(this.pkVal()), "selectById primaryKey is null.", new Object[0]);
        return this.selectById(this.pkVal());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> selectList(Wrapper<T> queryWrapper) {
        HashMap<String, Wrapper<T>> map = CollectionUtils.newHashMapWithExpectedSize(1);
        map.put("ew", queryWrapper);
        SqlSession sqlSession = this.sqlSession();
        try {
            List list = sqlSession.selectList(this.sqlStatement(SqlMethod.SELECT_LIST), map);
            return list;
        }
        finally {
            this.closeSqlSession(sqlSession);
        }
    }

    public T selectOne(Wrapper<T> queryWrapper) {
        return (T)((Model)SqlHelper.getObject(() -> LogFactory.getLog(this.entityClass), this.selectList(queryWrapper)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends IPage<T>> E selectPage(E page, Wrapper<T> queryWrapper) {
        HashMap<String, Wrapper<Object>> map = CollectionUtils.newHashMapWithExpectedSize(2);
        map.put("ew", queryWrapper);
        map.put("page", (Wrapper<Object>)((Object)page));
        SqlSession sqlSession = this.sqlSession();
        try {
            page.setRecords(sqlSession.selectList(this.sqlStatement(SqlMethod.SELECT_PAGE), map));
        }
        finally {
            this.closeSqlSession(sqlSession);
        }
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long selectCount(Wrapper<T> queryWrapper) {
        HashMap<String, Wrapper<T>> map = CollectionUtils.newHashMapWithExpectedSize(1);
        map.put("ew", queryWrapper);
        SqlSession sqlSession = this.sqlSession();
        try {
            long l = SqlHelper.retCount((Long)sqlSession.selectOne(this.sqlStatement(SqlMethod.SELECT_COUNT), map));
            return l;
        }
        finally {
            this.closeSqlSession(sqlSession);
        }
    }

    public SqlRunner sql() {
        return new SqlRunner(this.entityClass);
    }

    protected SqlSession sqlSession() {
        return SqlHelper.sqlSession(this.entityClass);
    }

    protected String sqlStatement(SqlMethod sqlMethod) {
        return this.sqlStatement(sqlMethod.getMethod());
    }

    protected String sqlStatement(String sqlMethod) {
        return SqlHelper.table(this.entityClass).getSqlStatement(sqlMethod);
    }

    public Serializable pkVal() {
        TableInfo tableInfo = TableInfoHelper.getTableInfo(this.entityClass);
        return (Serializable)tableInfo.getPropertyValue(this, tableInfo.getKeyProperty());
    }

    protected void closeSqlSession(SqlSession sqlSession) {
        SqlSessionUtils.closeSqlSession(sqlSession, GlobalConfigUtils.currentSessionFactory(this.entityClass));
    }
}

