/*
 * Decompiled with CFR 0.152.
 */
package top.tanmw.generator;

import cn.hutool.core.util.StrUtil;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.NullCacheStorage;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import java.io.File;
import java.io.IOException;

public class FreeMarkerTemplateUtils {
    private static final Configuration CONFIGURATION = new Configuration(Configuration.VERSION_2_3_30);

    private FreeMarkerTemplateUtils() {
    }

    public static void init(String templatePath) {
        if (StrUtil.isBlank(templatePath)) {
            CONFIGURATION.setTemplateLoader(new ClassTemplateLoader(FreeMarkerTemplateUtils.class, "/templates"));
        } else {
            try {
                CONFIGURATION.setTemplateLoader(new ClassTemplateLoader(FreeMarkerTemplateUtils.class, templatePath));
            }
            catch (Exception e) {
                try {
                    CONFIGURATION.setDirectoryForTemplateLoading(new File(templatePath));
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        CONFIGURATION.setDefaultEncoding("UTF-8");
        CONFIGURATION.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        CONFIGURATION.setCacheStorage(NullCacheStorage.INSTANCE);
    }

    public static Template getTemplate(String templateName) throws IOException {
        return CONFIGURATION.getTemplate(templateName);
    }

    public static void clearCache() {
        CONFIGURATION.clearTemplateCache();
    }
}

