/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.collection;

import cn.hutool.core.lang.Chain;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class IterChain<T>
implements Iterator<T>,
Chain<Iterator<T>, IterChain<T>> {
    protected final List<Iterator<T>> allIterators = new ArrayList<Iterator<T>>();
    protected int currentIter = -1;

    public IterChain() {
    }

    @SafeVarargs
    public IterChain(Iterator<T> ... iterators) {
        for (Iterator<T> iterator : iterators) {
            this.addChain(iterator);
        }
    }

    @Override
    public IterChain<T> addChain(Iterator<T> iterator) {
        if (this.allIterators.contains(iterator)) {
            throw new IllegalArgumentException("Duplicate iterator");
        }
        this.allIterators.add(iterator);
        return this;
    }

    @Override
    public boolean hasNext() {
        if (this.currentIter == -1) {
            this.currentIter = 0;
        }
        int size = this.allIterators.size();
        for (int i2 = this.currentIter; i2 < size; ++i2) {
            Iterator<T> iterator = this.allIterators.get(i2);
            if (!iterator.hasNext()) continue;
            this.currentIter = i2;
            return true;
        }
        return false;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.allIterators.get(this.currentIter).next();
    }

    @Override
    public void remove() {
        if (-1 == this.currentIter) {
            throw new IllegalStateException("next() has not yet been called");
        }
        this.allIterators.get(this.currentIter).remove();
    }

    @Override
    public Iterator<Iterator<T>> iterator() {
        return this.allIterators.iterator();
    }
}

