/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.img;

import cn.hutool.core.img.FontUtil;
import cn.hutool.core.img.ImgUtil;
import cn.hutool.core.util.ObjectUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

public class GraphicsUtil {
    public static Graphics2D createGraphics(BufferedImage image, Color color) {
        Graphics2D g2 = image.createGraphics();
        if (null != color) {
            g2.setColor(color);
            g2.fillRect(0, 0, image.getWidth(), image.getHeight());
        }
        return g2;
    }

    public static int getCenterY(Graphics g2, int backgroundHeight) {
        FontMetrics metrics = null;
        try {
            metrics = g2.getFontMetrics();
        }
        catch (Exception exception) {
            // empty catch block
        }
        int y2 = null != metrics ? (backgroundHeight - metrics.getHeight()) / 2 + metrics.getAscent() : backgroundHeight / 3;
        return y2;
    }

    public static Graphics drawStringColourful(Graphics g2, String str, Font font, int width, int height) {
        return GraphicsUtil.drawString(g2, str, font, null, width, height);
    }

    public static Graphics drawString(Graphics g2, String str, Font font, Color color, int width, int height) {
        if (g2 instanceof Graphics2D) {
            ((Graphics2D)g2).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g2.setFont(font);
        int midY = GraphicsUtil.getCenterY(g2, height);
        if (null != color) {
            g2.setColor(color);
        }
        int len = str.length();
        int charWidth = width / len;
        for (int i2 = 0; i2 < len; ++i2) {
            if (null == color) {
                g2.setColor(ImgUtil.randomColor());
            }
            g2.drawString(String.valueOf(str.charAt(i2)), i2 * charWidth, midY);
        }
        return g2;
    }

    public static Graphics drawString(Graphics g2, String str, Font font, Color color, Rectangle rectangle) {
        Dimension dimension;
        int backgroundWidth = rectangle.width;
        int backgroundHeight = rectangle.height;
        try {
            dimension = FontUtil.getDimension(g2.getFontMetrics(font), str);
        }
        catch (Exception e2) {
            dimension = new Dimension(backgroundWidth / 3, backgroundHeight / 3);
        }
        rectangle.setSize(dimension.width, dimension.height);
        Point point = ImgUtil.getPointBaseCentre(rectangle, backgroundWidth, backgroundHeight);
        return GraphicsUtil.drawString(g2, str, font, color, point);
    }

    public static Graphics drawString(Graphics g2, String str, Font font, Color color, Point point) {
        if (g2 instanceof Graphics2D) {
            ((Graphics2D)g2).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g2.setFont(font);
        g2.setColor(ObjectUtil.defaultIfNull(color, Color.BLACK));
        g2.drawString(str, point.x, point.y);
        return g2;
    }

    public static Graphics drawImg(Graphics g2, Image img, Point point) {
        return GraphicsUtil.drawImg(g2, img, new Rectangle(point.x, point.y, img.getWidth(null), img.getHeight(null)));
    }

    public static Graphics drawImg(Graphics g2, Image img, Rectangle rectangle) {
        g2.drawImage(img, rectangle.x, rectangle.y, rectangle.width, rectangle.height, null);
        return g2;
    }

    public static Graphics2D setAlpha(Graphics2D g2, float alpha) {
        g2.setComposite(AlphaComposite.getInstance(10, alpha));
        return g2;
    }
}

