/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.text;

import cn.hutool.core.lang.hash.MurmurHash;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.StampedLock;

public class Simhash {
    private final int bitNum = 64;
    private final int fracCount;
    private final int fracBitNum;
    private final int hammingThresh;
    private final List<Map<String, List<Long>>> storage;
    private final StampedLock lock = new StampedLock();

    public Simhash() {
        this(4, 3);
    }

    public Simhash(int fracCount, int hammingThresh) {
        this.fracCount = fracCount;
        this.fracBitNum = 64 / fracCount;
        this.hammingThresh = hammingThresh;
        this.storage = new ArrayList<Map<String, List<Long>>>(fracCount);
        for (int i2 = 0; i2 < fracCount; ++i2) {
            this.storage.add(new HashMap());
        }
    }

    /*
     * WARNING - void declaration
     */
    public long hash(Collection<? extends CharSequence> segList) {
        void var7_8;
        int bitNum = this.bitNum;
        int[] weight = new int[bitNum];
        for (CharSequence charSequence : segList) {
            long wordHash = MurmurHash.hash64(charSequence);
            for (int i2 = 0; i2 < bitNum; ++i2) {
                if ((wordHash >> i2 & 1L) == 1L) {
                    int n2 = i2;
                    weight[n2] = weight[n2] + 1;
                    continue;
                }
                int n3 = i2;
                weight[n3] = weight[n3] - 1;
            }
        }
        StringBuilder sb = new StringBuilder();
        boolean bl = false;
        while (var7_8 < bitNum) {
            sb.append(weight[var7_8] > 0 ? 1 : 0);
            ++var7_8;
        }
        return new BigInteger(sb.toString(), 2).longValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Collection<? extends CharSequence> segList) {
        long simhash = this.hash(segList);
        List<String> fracList = this.splitSimhash(simhash);
        int hammingThresh = this.hammingThresh;
        long stamp = this.lock.readLock();
        try {
            for (int i2 = 0; i2 < this.fracCount; ++i2) {
                String frac = fracList.get(i2);
                Map<String, List<Long>> fracMap = this.storage.get(i2);
                if (!fracMap.containsKey(frac)) continue;
                for (Long simhash2 : fracMap.get(frac)) {
                    if (this.hamming(simhash, simhash2) >= hammingThresh) continue;
                    boolean bl = true;
                    return bl;
                }
            }
        }
        finally {
            this.lock.unlockRead(stamp);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(Long simhash) {
        int fracCount = this.fracCount;
        List<Map<String, List<Long>>> storage = this.storage;
        List<String> lFrac = this.splitSimhash(simhash);
        long stamp = this.lock.writeLock();
        try {
            for (int i2 = 0; i2 < fracCount; ++i2) {
                String frac = lFrac.get(i2);
                Map<String, List<Long>> fracMap = storage.get(i2);
                if (fracMap.containsKey(frac)) {
                    fracMap.get(frac).add(simhash);
                    continue;
                }
                ArrayList<Long> ls = new ArrayList<Long>();
                ls.add(simhash);
                fracMap.put(frac, ls);
            }
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    private int hamming(Long s1, Long s2) {
        int bitNum = this.bitNum;
        int dis = 0;
        for (int i2 = 0; i2 < bitNum; ++i2) {
            if ((s1 >> i2 & 1L) == (s2 >> i2 & 1L)) continue;
            ++dis;
        }
        return dis;
    }

    private List<String> splitSimhash(Long simhash) {
        int bitNum = this.bitNum;
        int fracBitNum = this.fracBitNum;
        ArrayList<String> ls = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < bitNum; ++i2) {
            sb.append(simhash >> i2 & 1L);
            if ((i2 + 1) % fracBitNum != 0) continue;
            ls.add(sb.toString());
            sb.setLength(0);
        }
        return ls;
    }
}

