/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.reflection.wrapper;

import java.util.List;
import java.util.Map;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.ReflectionException;
import org.apache.ibatis.reflection.property.PropertyTokenizer;
import org.apache.ibatis.reflection.wrapper.ObjectWrapper;

public abstract class BaseWrapper
implements ObjectWrapper {
    protected static final Object[] NO_ARGUMENTS = new Object[0];
    protected final MetaObject metaObject;

    protected BaseWrapper(MetaObject metaObject) {
        this.metaObject = metaObject;
    }

    protected Object resolveCollection(PropertyTokenizer prop, Object object) {
        if ("".equals(prop.getName())) {
            return object;
        }
        return this.metaObject.getValue(prop.getName());
    }

    protected Object getCollectionValue(PropertyTokenizer prop, Object collection) {
        if (collection instanceof Map) {
            return ((Map)collection).get(prop.getIndex());
        }
        int i2 = Integer.parseInt(prop.getIndex());
        if (collection instanceof List) {
            return ((List)collection).get(i2);
        }
        if (collection instanceof Object[]) {
            return ((Object[])collection)[i2];
        }
        if (collection instanceof char[]) {
            return Character.valueOf(((char[])collection)[i2]);
        }
        if (collection instanceof boolean[]) {
            return ((boolean[])collection)[i2];
        }
        if (collection instanceof byte[]) {
            return ((byte[])collection)[i2];
        }
        if (collection instanceof double[]) {
            return ((double[])collection)[i2];
        }
        if (collection instanceof float[]) {
            return Float.valueOf(((float[])collection)[i2]);
        }
        if (collection instanceof int[]) {
            return ((int[])collection)[i2];
        }
        if (collection instanceof long[]) {
            return ((long[])collection)[i2];
        }
        if (collection instanceof short[]) {
            return ((short[])collection)[i2];
        }
        throw new ReflectionException("The '" + prop.getName() + "' property of " + collection + " is not a List or Array.");
    }

    protected void setCollectionValue(PropertyTokenizer prop, Object collection, Object value) {
        if (collection instanceof Map) {
            ((Map)collection).put(prop.getIndex(), value);
        } else {
            int i2 = Integer.parseInt(prop.getIndex());
            if (collection instanceof List) {
                ((List)collection).set(i2, value);
            } else if (collection instanceof Object[]) {
                ((Object[])collection)[i2] = value;
            } else if (collection instanceof char[]) {
                ((char[])collection)[i2] = ((Character)value).charValue();
            } else if (collection instanceof boolean[]) {
                ((boolean[])collection)[i2] = (Boolean)value;
            } else if (collection instanceof byte[]) {
                ((byte[])collection)[i2] = (Byte)value;
            } else if (collection instanceof double[]) {
                ((double[])collection)[i2] = (Double)value;
            } else if (collection instanceof float[]) {
                ((float[])collection)[i2] = ((Float)value).floatValue();
            } else if (collection instanceof int[]) {
                ((int[])collection)[i2] = (Integer)value;
            } else if (collection instanceof long[]) {
                ((long[])collection)[i2] = (Long)value;
            } else if (collection instanceof short[]) {
                ((short[])collection)[i2] = (Short)value;
            } else {
                throw new ReflectionException("The '" + prop.getName() + "' property of " + collection + " is not a List or Array.");
            }
        }
    }
}

