/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.pinyin;

import cn.hutool.extra.pinyin.PinyinEngine;
import cn.hutool.extra.pinyin.engine.PinyinFactory;

public class PinyinUtil {
    private static final String CHINESE_REGEX = "[\\u4e00-\\u9fa5]";

    public static PinyinEngine getEngine() {
        return PinyinFactory.get();
    }

    public static String getPinyin(char c2) {
        return PinyinUtil.getEngine().getPinyin(c2);
    }

    public static String getPinyin(String str) {
        return PinyinUtil.getPinyin(str, " ");
    }

    public static String getPinyin(String str, String separator) {
        return PinyinUtil.getEngine().getPinyin(str, separator);
    }

    public static char getFirstLetter(char c2) {
        return PinyinUtil.getEngine().getFirstLetter(c2);
    }

    public static String getFirstLetter(String str, String separator) {
        return PinyinUtil.getEngine().getFirstLetter(str, separator);
    }

    public static boolean isChinese(char c2) {
        return '\u3007' == c2 || String.valueOf(c2).matches(CHINESE_REGEX);
    }
}

