/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.log.dialect.log4j2;

import cn.hutool.core.util.StrUtil;
import cn.hutool.log.AbstractLog;
import cn.hutool.log.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.spi.AbstractLogger;

public class Log4j2Log
extends AbstractLog {
    private static final long serialVersionUID = -6843151523380063975L;
    private final transient Logger logger;

    public Log4j2Log(Logger logger) {
        this.logger = logger;
    }

    public Log4j2Log(Class<?> clazz) {
        this(LogManager.getLogger(clazz));
    }

    public Log4j2Log(String name) {
        this(LogManager.getLogger((String)name));
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public void trace(String fqcn, Throwable t2, String format, Object ... arguments) {
        this.logIfEnabled(fqcn, org.apache.logging.log4j.Level.TRACE, t2, format, arguments);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public void debug(String fqcn, Throwable t2, String format, Object ... arguments) {
        this.logIfEnabled(fqcn, org.apache.logging.log4j.Level.DEBUG, t2, format, arguments);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public void info(String fqcn, Throwable t2, String format, Object ... arguments) {
        this.logIfEnabled(fqcn, org.apache.logging.log4j.Level.INFO, t2, format, arguments);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    @Override
    public void warn(String fqcn, Throwable t2, String format, Object ... arguments) {
        this.logIfEnabled(fqcn, org.apache.logging.log4j.Level.WARN, t2, format, arguments);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    @Override
    public void error(String fqcn, Throwable t2, String format, Object ... arguments) {
        this.logIfEnabled(fqcn, org.apache.logging.log4j.Level.ERROR, t2, format, arguments);
    }

    @Override
    public void log(String fqcn, Level level, Throwable t2, String format, Object ... arguments) {
        org.apache.logging.log4j.Level log4j2Level;
        switch (level) {
            case TRACE: {
                log4j2Level = org.apache.logging.log4j.Level.TRACE;
                break;
            }
            case DEBUG: {
                log4j2Level = org.apache.logging.log4j.Level.DEBUG;
                break;
            }
            case INFO: {
                log4j2Level = org.apache.logging.log4j.Level.INFO;
                break;
            }
            case WARN: {
                log4j2Level = org.apache.logging.log4j.Level.WARN;
                break;
            }
            case ERROR: {
                log4j2Level = org.apache.logging.log4j.Level.ERROR;
                break;
            }
            default: {
                throw new Error(StrUtil.format("Can not identify level: {}", new Object[]{level}));
            }
        }
        this.logIfEnabled(fqcn, log4j2Level, t2, format, arguments);
    }

    private void logIfEnabled(String fqcn, org.apache.logging.log4j.Level level, Throwable t2, String msgTemplate, Object ... arguments) {
        if (this.logger.isEnabled(level)) {
            if (this.logger instanceof AbstractLogger) {
                ((AbstractLogger)this.logger).logIfEnabled(fqcn, level, null, StrUtil.format(msgTemplate, arguments), t2);
            } else {
                this.logger.log(level, StrUtil.format(msgTemplate, arguments), t2);
            }
        }
    }
}

