/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.result;

import com.mysql.cj.Constants;
import com.mysql.cj.Messages;
import com.mysql.cj.conf.PropertySet;
import com.mysql.cj.exceptions.NumberOutOfRange;
import com.mysql.cj.result.AbstractNumericValueFactory;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;

public class DoubleValueFactory
extends AbstractNumericValueFactory<Double> {
    public DoubleValueFactory(PropertySet pset) {
        super(pset);
    }

    @Override
    public Double createFromBigInteger(BigInteger i2) {
        if (this.jdbcCompliantTruncationForReads && (new BigDecimal(i2).compareTo(Constants.BIG_DECIMAL_MAX_NEGATIVE_DOUBLE_VALUE) < 0 || new BigDecimal(i2).compareTo(Constants.BIG_DECIMAL_MAX_DOUBLE_VALUE) > 0)) {
            throw new NumberOutOfRange(Messages.getString("ResultSet.NumberOutOfRange", new Object[]{i2, this.getTargetTypeName()}));
        }
        return i2.doubleValue();
    }

    @Override
    public Double createFromLong(long l2) {
        if (this.jdbcCompliantTruncationForReads && ((double)l2 < -1.7976931348623157E308 || (double)l2 > Double.MAX_VALUE)) {
            throw new NumberOutOfRange(Messages.getString("ResultSet.NumberOutOfRange", new Object[]{l2, this.getTargetTypeName()}));
        }
        return l2;
    }

    @Override
    public Double createFromBigDecimal(BigDecimal d2) {
        if (this.jdbcCompliantTruncationForReads && (d2.compareTo(Constants.BIG_DECIMAL_MAX_NEGATIVE_DOUBLE_VALUE) < 0 || d2.compareTo(Constants.BIG_DECIMAL_MAX_DOUBLE_VALUE) > 0)) {
            throw new NumberOutOfRange(Messages.getString("ResultSet.NumberOutOfRange", new Object[]{d2, this.getTargetTypeName()}));
        }
        return d2.doubleValue();
    }

    @Override
    public Double createFromDouble(double d2) {
        if (this.jdbcCompliantTruncationForReads && (d2 < -1.7976931348623157E308 || d2 > Double.MAX_VALUE)) {
            throw new NumberOutOfRange(Messages.getString("ResultSet.NumberOutOfRange", new Object[]{d2, this.getTargetTypeName()}));
        }
        return d2;
    }

    @Override
    public Double createFromBit(byte[] bytes, int offset, int length) {
        return new BigInteger(ByteBuffer.allocate(length + 1).put((byte)0).put(bytes, offset, length).array()).doubleValue();
    }

    @Override
    public String getTargetTypeName() {
        return Double.class.getName();
    }
}

