/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.text;

import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;

public class TextSimilarity {
    public static double similar(String strA, String strB) {
        String newStrB;
        String newStrA;
        if (strA.length() < strB.length()) {
            newStrA = TextSimilarity.removeSign(strB);
            newStrB = TextSimilarity.removeSign(strA);
        } else {
            newStrA = TextSimilarity.removeSign(strA);
            newStrB = TextSimilarity.removeSign(strB);
        }
        int temp = Math.max(newStrA.length(), newStrB.length());
        if (0 == temp) {
            return 1.0;
        }
        int commonLength = TextSimilarity.longestCommonSubstringLength(newStrA, newStrB);
        return NumberUtil.div((float)commonLength, (float)temp);
    }

    public static String similar(String strA, String strB, int scale) {
        return NumberUtil.formatPercent(TextSimilarity.similar(strA, strB), scale);
    }

    public static String longestCommonSubstring(String strA, String strB) {
        int[][] matrix = TextSimilarity.generateMatrix(strA, strB);
        int m3 = strA.length();
        int n2 = strB.length();
        char[] result = new char[matrix[m3][n2]];
        int currentIndex = result.length - 1;
        while (matrix[m3][n2] != 0) {
            if (matrix[m3][n2] == matrix[m3][n2 - 1]) {
                --n2;
                continue;
            }
            if (matrix[m3][n2] == matrix[m3 - 1][n2]) {
                --m3;
                continue;
            }
            result[currentIndex] = strA.charAt(m3 - 1);
            --currentIndex;
            --n2;
            --m3;
        }
        return new String(result);
    }

    private static String removeSign(String str) {
        int length = str.length();
        StringBuilder sb = StrUtil.builder(length);
        for (int i2 = 0; i2 < length; ++i2) {
            char c2 = str.charAt(i2);
            if (!TextSimilarity.isValidChar(c2)) continue;
            sb.append(c2);
        }
        return sb.toString();
    }

    private static boolean isValidChar(char charValue) {
        return charValue >= '\u4e00' && charValue <= '\u9fff' || charValue >= 'a' && charValue <= 'z' || charValue >= 'A' && charValue <= 'Z' || charValue >= '0' && charValue <= '9';
    }

    private static int longestCommonSubstringLength(String strA, String strB) {
        int m3 = strA.length();
        int n2 = strB.length();
        return TextSimilarity.generateMatrix(strA, strB)[m3][n2];
    }

    private static int[][] generateMatrix(String strA, String strB) {
        int m3 = strA.length();
        int n2 = strB.length();
        int[][] matrix = new int[m3 + 1][n2 + 1];
        for (int i2 = 1; i2 <= m3; ++i2) {
            for (int j2 = 1; j2 <= n2; ++j2) {
                matrix[i2][j2] = strA.charAt(i2 - 1) == strB.charAt(j2 - 1) ? matrix[i2 - 1][j2 - 1] + 1 : Math.max(matrix[i2][j2 - 1], matrix[i2 - 1][j2]);
            }
        }
        return matrix;
    }
}

