/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto.symmetric;

import cn.hutool.core.io.IoUtil;
import cn.hutool.crypto.symmetric.SymmetricDecryptor;
import cn.hutool.crypto.symmetric.SymmetricEncryptor;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class XXTEA
implements SymmetricEncryptor,
SymmetricDecryptor,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int DELTA = -1640531527;
    private final byte[] key;

    public XXTEA(byte[] key) {
        this.key = key;
    }

    @Override
    public byte[] encrypt(byte[] data) {
        if (data.length == 0) {
            return data;
        }
        return XXTEA.toByteArray(XXTEA.encrypt(XXTEA.toIntArray(data, true), XXTEA.toIntArray(XXTEA.fixKey(this.key), false)), false);
    }

    @Override
    public void encrypt(InputStream data, OutputStream out, boolean isClose) {
        IoUtil.write(out, isClose, this.encrypt(IoUtil.readBytes(data)));
    }

    @Override
    public byte[] decrypt(byte[] data) {
        if (data.length == 0) {
            return data;
        }
        return XXTEA.toByteArray(XXTEA.decrypt(XXTEA.toIntArray(data, false), XXTEA.toIntArray(XXTEA.fixKey(this.key), false)), true);
    }

    @Override
    public void decrypt(InputStream data, OutputStream out, boolean isClose) {
        IoUtil.write(out, isClose, this.decrypt(IoUtil.readBytes(data)));
    }

    private static int[] encrypt(int[] v2, int[] k2) {
        int n2 = v2.length - 1;
        if (n2 < 1) {
            return v2;
        }
        int q2 = 6 + 52 / (n2 + 1);
        int z2 = v2[n2];
        int sum = 0;
        while (q2-- > 0) {
            int y2;
            int p2;
            int e2 = (sum += -1640531527) >>> 2 & 3;
            for (p2 = 0; p2 < n2; ++p2) {
                y2 = v2[p2 + 1];
                int n3 = p2;
                int n4 = v2[n3] + XXTEA.mx(sum, y2, z2, p2, e2, k2);
                v2[n3] = n4;
                z2 = n4;
            }
            y2 = v2[0];
            int n5 = n2;
            int n6 = v2[n5] + XXTEA.mx(sum, y2, z2, p2, e2, k2);
            v2[n5] = n6;
            z2 = n6;
        }
        return v2;
    }

    private static int[] decrypt(int[] v2, int[] k2) {
        int n2 = v2.length - 1;
        if (n2 < 1) {
            return v2;
        }
        int q2 = 6 + 52 / (n2 + 1);
        int y2 = v2[0];
        for (int sum = q2 * -1640531527; sum != 0; sum -= -1640531527) {
            int z2;
            int p2;
            int e2 = sum >>> 2 & 3;
            for (p2 = n2; p2 > 0; --p2) {
                z2 = v2[p2 - 1];
                int n3 = p2;
                int n4 = v2[n3] - XXTEA.mx(sum, y2, z2, p2, e2, k2);
                v2[n3] = n4;
                y2 = n4;
            }
            z2 = v2[n2];
            y2 = v2[0] = v2[0] - XXTEA.mx(sum, y2, z2, p2, e2, k2);
        }
        return v2;
    }

    private static int mx(int sum, int y2, int z2, int p2, int e2, int[] k2) {
        return (z2 >>> 5 ^ y2 << 2) + (y2 >>> 3 ^ z2 << 4) ^ (sum ^ y2) + (k2[p2 & 3 ^ e2] ^ z2);
    }

    private static byte[] fixKey(byte[] key) {
        if (key.length == 16) {
            return key;
        }
        byte[] fixedkey = new byte[16];
        System.arraycopy(key, 0, fixedkey, 0, Math.min(key.length, 16));
        return fixedkey;
    }

    private static int[] toIntArray(byte[] data, boolean includeLength) {
        int[] result;
        int n2;
        int n3 = n2 = (data.length & 3) == 0 ? data.length >>> 2 : (data.length >>> 2) + 1;
        if (includeLength) {
            result = new int[n2 + 1];
            result[n2] = data.length;
        } else {
            result = new int[n2];
        }
        n2 = data.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = i2 >>> 2;
            result[n4] = result[n4] | (0xFF & data[i2]) << ((i2 & 3) << 3);
        }
        return result;
    }

    private static byte[] toByteArray(int[] data, boolean includeLength) {
        int n2 = data.length << 2;
        if (includeLength) {
            int m3 = data[data.length - 1];
            if (m3 < (n2 -= 4) - 3 || m3 > n2) {
                return null;
            }
            n2 = m3;
        }
        byte[] result = new byte[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            result[i2] = (byte)(data[i2 >>> 2] >>> ((i2 & 3) << 3));
        }
        return result;
    }
}

