/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.dfa;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Filter;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.dfa.FoundWord;
import cn.hutool.dfa.SensitiveProcessor;
import cn.hutool.dfa.WordTree;
import cn.hutool.json.JSONUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public final class SensitiveUtil {
    public static final char DEFAULT_SEPARATOR = ',';
    private static final WordTree sensitiveTree = new WordTree();

    public static boolean isInited() {
        return false == sensitiveTree.isEmpty();
    }

    public static void init(Collection<String> sensitiveWords, boolean isAsync) {
        if (isAsync) {
            ThreadUtil.execAsync(() -> {
                SensitiveUtil.init(sensitiveWords);
                return true;
            });
        } else {
            SensitiveUtil.init(sensitiveWords);
        }
    }

    public static void init(Collection<String> sensitiveWords) {
        sensitiveTree.clear();
        sensitiveTree.addWords(sensitiveWords);
    }

    public static void init(String sensitiveWords, char separator, boolean isAsync) {
        if (StrUtil.isNotBlank(sensitiveWords)) {
            SensitiveUtil.init(StrUtil.split((CharSequence)sensitiveWords, separator), isAsync);
        }
    }

    public static void init(String sensitiveWords, boolean isAsync) {
        SensitiveUtil.init(sensitiveWords, ',', isAsync);
    }

    public static void setCharFilter(Filter<Character> charFilter) {
        if (charFilter != null) {
            sensitiveTree.setCharFilter(charFilter);
        }
    }

    public static boolean containsSensitive(String text) {
        return sensitiveTree.isMatch(text);
    }

    public static boolean containsSensitive(Object obj) {
        return sensitiveTree.isMatch(JSONUtil.toJsonStr(obj));
    }

    public static FoundWord getFoundFirstSensitive(String text) {
        return sensitiveTree.matchWord(text);
    }

    public static FoundWord getFoundFirstSensitive(Object obj) {
        return sensitiveTree.matchWord(JSONUtil.toJsonStr(obj));
    }

    public static List<FoundWord> getFoundAllSensitive(String text) {
        return sensitiveTree.matchAllWords(text);
    }

    public static List<FoundWord> getFoundAllSensitive(String text, boolean isDensityMatch, boolean isGreedMatch) {
        return sensitiveTree.matchAllWords(text, -1, isDensityMatch, isGreedMatch);
    }

    public static List<FoundWord> getFoundAllSensitive(Object bean) {
        return sensitiveTree.matchAllWords(JSONUtil.toJsonStr(bean));
    }

    public static List<FoundWord> getFoundAllSensitive(Object bean, boolean isDensityMatch, boolean isGreedMatch) {
        return SensitiveUtil.getFoundAllSensitive(JSONUtil.toJsonStr(bean), isDensityMatch, isGreedMatch);
    }

    public static <T> T sensitiveFilter(T bean, boolean isGreedMatch, SensitiveProcessor sensitiveProcessor) {
        String jsonText = JSONUtil.toJsonStr(bean);
        Class<?> c2 = bean.getClass();
        return (T)JSONUtil.toBean(SensitiveUtil.sensitiveFilter(jsonText, isGreedMatch, sensitiveProcessor), c2);
    }

    public static String sensitiveFilter(String text) {
        return SensitiveUtil.sensitiveFilter(text, true, null);
    }

    public static String sensitiveFilter(String text, boolean isGreedMatch, SensitiveProcessor sensitiveProcessor) {
        if (StrUtil.isEmpty(text)) {
            return text;
        }
        List<FoundWord> foundWordList = SensitiveUtil.getFoundAllSensitive(text, true, isGreedMatch);
        if (CollUtil.isEmpty(foundWordList)) {
            return text;
        }
        sensitiveProcessor = sensitiveProcessor == null ? new SensitiveProcessor(){} : sensitiveProcessor;
        HashMap foundWordMap = new HashMap(foundWordList.size(), 1.0f);
        foundWordList.forEach(foundWord -> foundWordMap.put(foundWord.getStartIndex(), foundWord));
        int length = text.length();
        StringBuilder textStringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < length; ++i2) {
            FoundWord fw = (FoundWord)foundWordMap.get(i2);
            if (fw != null) {
                textStringBuilder.append(sensitiveProcessor.process(fw));
                i2 = (Integer)fw.getEndIndex();
                continue;
            }
            textStringBuilder.append(text.charAt(i2));
        }
        return textStringBuilder.toString();
    }
}

