/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.ddl;

import com.baomidou.mybatisplus.extension.ddl.history.IDdlGenerator;
import com.baomidou.mybatisplus.extension.ddl.history.MysqlDdlGenerator;
import com.baomidou.mybatisplus.extension.ddl.history.OracleDdlGenerator;
import com.baomidou.mybatisplus.extension.ddl.history.PostgreDdlGenerator;
import com.baomidou.mybatisplus.extension.plugins.pagination.DialectFactory;
import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.IDialect;
import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.MySqlDialect;
import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.Oracle12cDialect;
import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.OracleDialect;
import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.PostgreDialect;
import com.baomidou.mybatisplus.extension.toolkit.JdbcUtils;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.apache.ibatis.jdbc.SqlRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

public class DdlHelper {
    private static final Logger log = LoggerFactory.getLogger(DdlHelper.class);

    public static void runScript(IDdlGenerator ddlGenerator, Connection connection, List<String> sqlFiles, boolean autoCommit) throws SQLException {
        String jdbcUrl = connection.getMetaData().getURL();
        String schema = DdlHelper.getDatabase(jdbcUrl);
        SqlRunner sqlRunner = new SqlRunner(connection);
        ScriptRunner scriptRunner = DdlHelper.getScriptRunner(connection, autoCommit);
        if (null == ddlGenerator) {
            ddlGenerator = DdlHelper.getDdlGenerator(jdbcUrl);
        }
        if (!ddlGenerator.existTable(schema, sql -> {
            try {
                Map<String, Object> resultMap = sqlRunner.selectOne((String)sql, new Object[0]);
                if (null != resultMap && !"0".equals(String.valueOf(resultMap.get("NUM")))) {
                    return true;
                }
            }
            catch (SQLException e2) {
                log.error("run script sql:{} , error: {}", sql, (Object)e2.getMessage());
            }
            return false;
        })) {
            scriptRunner.runScript(new StringReader(ddlGenerator.createDdlHistory()));
        }
        for (String sqlFile : sqlFiles) {
            try {
                List<Map<String, Object>> objectMap = sqlRunner.selectAll(ddlGenerator.selectDdlHistory(sqlFile, "sql"), new Object[0]);
                if (null != objectMap && !objectMap.isEmpty()) continue;
                log.debug("run script file: {}", (Object)sqlFile);
                File file = new File(sqlFile);
                if (file.exists()) {
                    scriptRunner.runScript(new FileReader(file));
                } else {
                    scriptRunner.runScript(new InputStreamReader(DdlHelper.getInputStream(sqlFile)));
                }
                sqlRunner.insert(ddlGenerator.insertDdlHistory(sqlFile, "sql", DdlHelper.getNowTime()), new Object[0]);
            }
            catch (Exception e2) {
                log.error("run script sql:{} , error: {} , Please check if the table `ddl_history` exists", (Object)sqlFile, (Object)e2.getMessage());
            }
        }
    }

    public static void runScript(IDdlGenerator ddlGenerator, DataSource dataSource, List<String> sqlFiles, boolean autoCommit) {
        try (Connection connection = dataSource.getConnection();){
            DdlHelper.runScript(ddlGenerator, connection, sqlFiles, autoCommit);
        }
        catch (Exception e2) {
            log.error("run script error: {}", (Object)e2.getMessage());
        }
    }

    public static InputStream getInputStream(String path) throws Exception {
        return new ClassPathResource(path).getInputStream();
    }

    protected static String getNowTime() {
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmm"));
    }

    public static ScriptRunner getScriptRunner(Connection connection, boolean autoCommit) {
        ScriptRunner scriptRunner = new ScriptRunner(connection);
        scriptRunner.setAutoCommit(autoCommit);
        scriptRunner.setStopOnError(true);
        return scriptRunner;
    }

    protected static IDdlGenerator getDdlGenerator(String jdbcUrl) throws RuntimeException {
        IDialect dialect = DialectFactory.getDialect(JdbcUtils.getDbType(jdbcUrl));
        if (dialect instanceof MySqlDialect) {
            return MysqlDdlGenerator.newInstance();
        }
        if (dialect instanceof PostgreDialect) {
            return PostgreDdlGenerator.newInstance();
        }
        if (dialect instanceof OracleDialect || dialect instanceof Oracle12cDialect) {
            return OracleDdlGenerator.newInstance();
        }
        throw new RuntimeException("The database is not supported");
    }

    public static String getDatabase(String jdbcUrl) {
        String[] dataArr;
        String[] urlArr = jdbcUrl.split("://");
        if (urlArr.length == 2 && (dataArr = urlArr[1].split("/")).length > 1) {
            return dataArr[1].split("\\?")[0];
        }
        return null;
    }
}

