/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.parser.ASTNodeAccessImpl;
import net.sf.jsqlparser.statement.select.OrderByElement;

public class KeepExpression
extends ASTNodeAccessImpl
implements Expression {
    private String name;
    private List<OrderByElement> orderByElements;
    private boolean first = false;

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public List<OrderByElement> getOrderByElements() {
        return this.orderByElements;
    }

    public void setOrderByElements(List<OrderByElement> orderByElements) {
        this.orderByElements = orderByElements;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isFirst() {
        return this.first;
    }

    public void setFirst(boolean first) {
        this.first = first;
    }

    public String toString() {
        StringBuilder b2 = new StringBuilder();
        b2.append("KEEP (").append(this.name);
        b2.append(" ").append(this.first ? "FIRST" : "LAST").append(" ");
        this.toStringOrderByElements(b2);
        b2.append(")");
        return b2.toString();
    }

    private void toStringOrderByElements(StringBuilder b2) {
        if (this.orderByElements != null && !this.orderByElements.isEmpty()) {
            b2.append("ORDER BY ");
            for (int i2 = 0; i2 < this.orderByElements.size(); ++i2) {
                if (i2 > 0) {
                    b2.append(", ");
                }
                b2.append(this.orderByElements.get(i2).toString());
            }
        }
    }

    public KeepExpression withName(String name) {
        this.setName(name);
        return this;
    }

    public KeepExpression withOrderByElements(List<OrderByElement> orderByElements) {
        this.setOrderByElements(orderByElements);
        return this;
    }

    public KeepExpression withFirst(boolean first) {
        this.setFirst(first);
        return this;
    }

    public KeepExpression addOrderByElements(OrderByElement ... orderByElements) {
        List collection = Optional.ofNullable(this.getOrderByElements()).orElseGet(ArrayList::new);
        Collections.addAll(collection, orderByElements);
        return this.withOrderByElements(collection);
    }

    public KeepExpression addOrderByElements(Collection<? extends OrderByElement> orderByElements) {
        List collection = Optional.ofNullable(this.getOrderByElements()).orElseGet(ArrayList::new);
        collection.addAll(orderByElements);
        return this.withOrderByElements(collection);
    }
}

