/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.validation.validator;

import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.MySQLIndexHint;
import net.sf.jsqlparser.expression.SQLServerHints;
import net.sf.jsqlparser.parser.feature.Feature;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.ExceptOp;
import net.sf.jsqlparser.statement.select.Fetch;
import net.sf.jsqlparser.statement.select.FromItemVisitor;
import net.sf.jsqlparser.statement.select.IntersectOp;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.LateralSubSelect;
import net.sf.jsqlparser.statement.select.MinusOp;
import net.sf.jsqlparser.statement.select.Offset;
import net.sf.jsqlparser.statement.select.ParenthesisFromItem;
import net.sf.jsqlparser.statement.select.Pivot;
import net.sf.jsqlparser.statement.select.PivotVisitor;
import net.sf.jsqlparser.statement.select.PivotXml;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SelectItemVisitor;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.SubJoin;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.select.TableFunction;
import net.sf.jsqlparser.statement.select.UnPivot;
import net.sf.jsqlparser.statement.select.UnionOp;
import net.sf.jsqlparser.statement.select.ValuesList;
import net.sf.jsqlparser.statement.select.WithItem;
import net.sf.jsqlparser.statement.values.ValuesStatement;
import net.sf.jsqlparser.util.validation.ValidationCapability;
import net.sf.jsqlparser.util.validation.ValidationUtil;
import net.sf.jsqlparser.util.validation.metadata.NamedObject;
import net.sf.jsqlparser.util.validation.validator.AbstractValidator;
import net.sf.jsqlparser.util.validation.validator.ExpressionValidator;
import net.sf.jsqlparser.util.validation.validator.GroupByValidator;
import net.sf.jsqlparser.util.validation.validator.LimitValidator;
import net.sf.jsqlparser.util.validation.validator.ValuesStatementValidator;

public class SelectValidator
extends AbstractValidator<SelectItem>
implements SelectVisitor,
SelectItemVisitor,
FromItemVisitor,
PivotVisitor {
    @Override
    public void visit(PlainSelect plainSelect) {
        for (ValidationCapability c2 : this.getCapabilities()) {
            this.validateFeature(c2, Feature.select);
            this.validateFeature(c2, plainSelect.getMySqlHintStraightJoin(), Feature.mySqlHintStraightJoin);
            this.validateOptionalFeature(c2, plainSelect.getOracleHint(), Feature.oracleHint);
            this.validateOptionalFeature(c2, plainSelect.getSkip(), Feature.skip);
            this.validateOptionalFeature(c2, plainSelect.getFirst(), Feature.first);
            if (plainSelect.getDistinct() != null) {
                if (plainSelect.getDistinct().isUseUnique()) {
                    this.validateFeature(c2, Feature.selectUnique);
                } else {
                    this.validateFeature(c2, Feature.distinct);
                }
                this.validateOptionalFeature(c2, plainSelect.getDistinct().getOnSelectItems(), Feature.distinctOn);
            }
            this.validateOptionalFeature(c2, plainSelect.getTop(), Feature.top);
            this.validateFeature(c2, plainSelect.getMySqlSqlCacheFlag() != null, Feature.mysqlSqlCacheFlag);
            this.validateFeature(c2, plainSelect.getMySqlSqlCalcFoundRows(), Feature.mysqlCalcFoundRows);
            this.validateOptionalFeature(c2, plainSelect.getIntoTables(), Feature.selectInto);
            this.validateOptionalFeature(c2, plainSelect.getKsqlWindow(), Feature.kSqlWindow);
            this.validateFeature(c2, this.isNotEmpty(plainSelect.getOrderByElements()) && plainSelect.isOracleSiblings(), Feature.oracleOrderBySiblings);
            if (plainSelect.isForUpdate()) {
                this.validateFeature(c2, Feature.selectForUpdate);
                this.validateOptionalFeature(c2, plainSelect.getForUpdateTable(), Feature.selectForUpdateOfTable);
                this.validateOptionalFeature(c2, plainSelect.getWait(), Feature.selectForUpdateWait);
                this.validateFeature(c2, plainSelect.isNoWait(), Feature.selectForUpdateNoWait);
            }
            this.validateOptionalFeature(c2, plainSelect.getForXmlPath(), Feature.selectForXmlPath);
            this.validateOptionalFeature(c2, plainSelect.getOptimizeFor(), Feature.optimizeFor);
        }
        this.validateOptionalFromItem(plainSelect.getFromItem());
        this.validateOptionalFromItems(plainSelect.getIntoTables());
        this.validateOptionalJoins(plainSelect.getJoins());
        this.validateOptionalList(plainSelect.getSelectItems(), () -> this, (e2, v2) -> e2.accept((SelectItemVisitor)v2));
        this.validateOptionalExpression(plainSelect.getWhere());
        this.validateOptionalExpression(plainSelect.getOracleHierarchical());
        if (plainSelect.getGroupBy() != null) {
            plainSelect.getGroupBy().accept(this.getValidator(GroupByValidator.class));
        }
        this.validateOptionalExpression(plainSelect.getHaving());
        this.validateOptionalOrderByElements(plainSelect.getOrderByElements());
        if (plainSelect.getLimit() != null) {
            this.getValidator(LimitValidator.class).validate(plainSelect.getLimit());
        }
        if (plainSelect.getOffset() != null) {
            this.validateOffset(plainSelect.getOffset());
        }
        if (plainSelect.getFetch() != null) {
            this.validateFetch(plainSelect.getFetch());
        }
    }

    @Override
    public void visit(AllTableColumns allTableColumns) {
    }

    @Override
    public void visit(AllColumns allColumns) {
    }

    @Override
    public void visit(SelectExpressionItem selectExpressionItem) {
        selectExpressionItem.getExpression().accept(this.getValidator(ExpressionValidator.class));
    }

    @Override
    public void visit(SubSelect subSelect) {
        if (this.isNotEmpty(subSelect.getWithItemsList())) {
            subSelect.getWithItemsList().forEach(withItem -> withItem.accept(this));
        }
        subSelect.getSelectBody().accept(this);
        this.validateOptional(subSelect.getPivot(), p2 -> p2.accept(this));
    }

    @Override
    public void visit(Table table) {
        SQLServerHints sqlServerHints;
        this.validateNameWithAlias(NamedObject.table, table.getFullyQualifiedName(), ValidationUtil.getAlias(table.getAlias()));
        this.validateOptional(table.getPivot(), p2 -> p2.accept(this));
        this.validateOptional(table.getUnPivot(), up -> up.accept(this));
        MySQLIndexHint indexHint = table.getIndexHint();
        if (indexHint != null && this.isNotEmpty(indexHint.getIndexNames())) {
            indexHint.getIndexNames().forEach(i2 -> this.validateName(NamedObject.index, (String)i2));
        }
        if ((sqlServerHints = table.getSqlServerHints()) != null) {
            this.validateName(NamedObject.index, sqlServerHints.getIndexName());
        }
    }

    @Override
    public void visit(Pivot pivot) {
        this.validateFeature(Feature.pivot);
        this.validateOptionalExpressions(pivot.getForColumns());
    }

    @Override
    public void visit(UnPivot unpivot) {
        this.validateFeature(Feature.unpivot);
        this.validateOptionalExpressions(unpivot.getUnPivotForClause());
        this.validateOptionalExpressions(unpivot.getUnPivotClause());
    }

    @Override
    public void visit(PivotXml pivot) {
        this.validateFeature(Feature.pivotXml);
        this.validateOptionalExpressions(pivot.getForColumns());
        if (this.isNotEmpty(pivot.getFunctionItems())) {
            ExpressionValidator v2 = this.getValidator(ExpressionValidator.class);
            pivot.getFunctionItems().forEach(f2 -> f2.getFunction().accept(v2));
        }
        if (pivot.getInSelect() != null) {
            pivot.getInSelect().accept(this);
        }
    }

    public void validateOffset(Offset offset) {
        for (ValidationCapability c2 : this.getCapabilities()) {
            this.validateFeature(c2, Feature.offset);
            this.validateOptionalFeature(c2, offset.getOffsetParam(), Feature.offsetParam);
        }
    }

    public void validateFetch(Fetch fetch) {
        for (ValidationCapability c2 : this.getCapabilities()) {
            this.validateFeature(c2, Feature.fetch);
            this.validateFeature(c2, fetch.isFetchParamFirst(), Feature.fetchFirst);
            this.validateFeature(c2, !fetch.isFetchParamFirst(), Feature.fetchNext);
        }
        this.validateOptionalExpression(fetch.getFetchJdbcParameter());
    }

    @Override
    public void visit(SubJoin subjoin) {
        this.validateOptionalFromItem(subjoin.getLeft());
        this.validateOptionalJoins(subjoin.getJoinList());
        this.validateOptional(subjoin.getPivot(), e2 -> e2.accept(this));
    }

    public void validateOptionalJoins(List<Join> joins) {
        if (joins != null) {
            for (Join join : joins) {
                this.validateOptionalJoin(join);
            }
        }
    }

    public void validateOptionalJoin(Join join) {
        for (ValidationCapability c2 : this.getCapabilities()) {
            this.validateFeature(c2, Feature.join);
            this.validateFeature(c2, join.isSimple() && join.isOuter(), Feature.joinOuterSimple);
            this.validateFeature(c2, join.isSimple(), Feature.joinSimple);
            this.validateFeature(c2, join.isRight(), Feature.joinRight);
            this.validateFeature(c2, join.isNatural(), Feature.joinNatural);
            this.validateFeature(c2, join.isFull(), Feature.joinFull);
            this.validateFeature(c2, join.isLeft(), Feature.joinLeft);
            this.validateFeature(c2, join.isCross(), Feature.joinCross);
            this.validateFeature(c2, join.isOuter(), Feature.joinOuter);
            this.validateFeature(c2, join.isInner(), Feature.joinInner);
            this.validateFeature(c2, join.isSemi(), Feature.joinSemi);
            this.validateFeature(c2, join.isStraight(), Feature.joinStraight);
            this.validateFeature(c2, join.isApply(), Feature.joinApply);
            this.validateFeature(c2, join.isWindowJoin(), Feature.joinWindow);
            this.validateOptionalFeature(c2, join.getUsingColumns(), Feature.joinUsingColumns);
        }
        this.validateOptionalFromItem(join.getRightItem());
        for (Expression onExpression : join.getOnExpressions()) {
            this.validateOptionalExpression(onExpression);
        }
        this.validateOptionalExpressions(join.getUsingColumns());
    }

    @Override
    public void visit(SetOperationList setOperation) {
        for (ValidationCapability c2 : this.getCapabilities()) {
            this.validateFeature(c2, Feature.setOperation);
            this.validateFeature(c2, setOperation.getOperations().stream().anyMatch(o2 -> o2 instanceof UnionOp), Feature.setOperationUnion);
            this.validateFeature(c2, setOperation.getOperations().stream().anyMatch(o2 -> o2 instanceof IntersectOp), Feature.setOperationIntersect);
            this.validateFeature(c2, setOperation.getOperations().stream().anyMatch(o2 -> o2 instanceof ExceptOp), Feature.setOperationExcept);
            this.validateFeature(c2, setOperation.getOperations().stream().anyMatch(o2 -> o2 instanceof MinusOp), Feature.setOperationMinus);
        }
        if (this.isNotEmpty(setOperation.getSelects())) {
            setOperation.getSelects().forEach(s2 -> s2.accept(this));
        }
        this.validateOptionalOrderByElements(setOperation.getOrderByElements());
        if (setOperation.getLimit() != null) {
            this.getValidator(LimitValidator.class).validate(setOperation.getLimit());
        }
        if (setOperation.getOffset() != null) {
            this.validateOffset(setOperation.getOffset());
        }
        if (setOperation.getFetch() != null) {
            this.validateFetch(setOperation.getFetch());
        }
    }

    @Override
    public void visit(WithItem withItem) {
        for (ValidationCapability c2 : this.getCapabilities()) {
            this.validateFeature(c2, Feature.withItem);
            this.validateFeature(c2, withItem.isRecursive(), Feature.withItemRecursive);
        }
        if (this.isNotEmpty(withItem.getWithItemList())) {
            withItem.getWithItemList().forEach(wi -> wi.accept(this));
        }
        withItem.getSubSelect().accept(this);
    }

    @Override
    public void visit(LateralSubSelect lateralSubSelect) {
        this.validateFeature(Feature.lateralSubSelect);
        this.validateOptional(lateralSubSelect.getPivot(), p2 -> p2.accept(this));
        this.validateOptional(lateralSubSelect.getUnPivot(), up -> up.accept(this));
        this.validateOptional(lateralSubSelect.getSubSelect(), e2 -> e2.accept(this));
    }

    @Override
    public void visit(ValuesList valuesList) {
        this.validateFeature(Feature.valuesList);
        this.validateOptionalMultiExpressionList(valuesList.getMultiExpressionList());
    }

    @Override
    public void visit(TableFunction tableFunction) {
        this.validateFeature(Feature.tableFunction);
        this.validateOptional(tableFunction.getPivot(), p2 -> p2.accept(this));
        this.validateOptional(tableFunction.getUnPivot(), up -> up.accept(this));
    }

    @Override
    public void visit(ParenthesisFromItem parenthesis) {
        this.validateOptional(parenthesis.getFromItem(), e2 -> e2.accept(this));
    }

    @Override
    public void visit(ValuesStatement values) {
        this.getValidator(ValuesStatementValidator.class).validate(values);
    }

    @Override
    public void validate(SelectItem statement) {
        statement.accept(this);
    }
}

