/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.ognl;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.apache.ibatis.ognl.NodeType;
import org.apache.ibatis.ognl.OgnlContext;
import org.apache.ibatis.ognl.OgnlException;
import org.apache.ibatis.ognl.OgnlOps;
import org.apache.ibatis.ognl.OgnlParser;
import org.apache.ibatis.ognl.OgnlRuntime;
import org.apache.ibatis.ognl.SimpleNode;

public class ASTStaticField
extends SimpleNode
implements NodeType {
    private String className;
    private String fieldName;
    private Class _getterClass;

    public ASTStaticField(int id) {
        super(id);
    }

    public ASTStaticField(OgnlParser p2, int id) {
        super(p2, id);
    }

    void init(String className, String fieldName) {
        this.className = className;
        this.fieldName = fieldName;
    }

    @Override
    protected Object getValueBody(OgnlContext context, Object source) throws OgnlException {
        return OgnlRuntime.getStaticField(context, this.className, this.fieldName);
    }

    @Override
    public boolean isNodeConstant(OgnlContext context) throws OgnlException {
        boolean result = false;
        Exception reason = null;
        try {
            Class c2 = OgnlRuntime.classForName(context, this.className);
            if (this.fieldName.equals("class")) {
                result = true;
            } else if (c2.isEnum()) {
                result = true;
            } else {
                Field f2 = OgnlRuntime.getField(c2, this.fieldName);
                if (f2 == null) {
                    throw new NoSuchFieldException(this.fieldName);
                }
                if (!Modifier.isStatic(f2.getModifiers())) {
                    throw new OgnlException("Field " + this.fieldName + " of class " + this.className + " is not static");
                }
                result = Modifier.isFinal(f2.getModifiers());
            }
        }
        catch (ClassNotFoundException e2) {
            reason = e2;
        }
        catch (NoSuchFieldException e3) {
            reason = e3;
        }
        catch (SecurityException e4) {
            reason = e4;
        }
        if (reason != null) {
            throw new OgnlException("Could not get static field " + this.fieldName + " from class " + this.className, reason);
        }
        return result;
    }

    Class getFieldClass(OgnlContext context) throws OgnlException {
        Exception reason = null;
        try {
            Class c2 = OgnlRuntime.classForName(context, this.className);
            if (this.fieldName.equals("class")) {
                return c2;
            }
            if (c2.isEnum()) {
                return c2;
            }
            Field f2 = c2.getField(this.fieldName);
            return f2.getType();
        }
        catch (ClassNotFoundException e2) {
            reason = e2;
        }
        catch (NoSuchFieldException e3) {
            reason = e3;
        }
        catch (SecurityException e4) {
            reason = e4;
        }
        if (reason != null) {
            throw new OgnlException("Could not get static field " + this.fieldName + " from class " + this.className, reason);
        }
        return null;
    }

    @Override
    public Class getGetterClass() {
        return this._getterClass;
    }

    @Override
    public Class getSetterClass() {
        return this._getterClass;
    }

    @Override
    public String toString() {
        return "@" + this.className + "@" + this.fieldName;
    }

    @Override
    public String toGetSourceString(OgnlContext context, Object target) {
        try {
            Object obj = OgnlRuntime.getStaticField(context, this.className, this.fieldName);
            context.setCurrentObject(obj);
            this._getterClass = this.getFieldClass(context);
            context.setCurrentType(this._getterClass);
        }
        catch (Throwable t2) {
            throw OgnlOps.castToRuntime(t2);
        }
        return this.className + "." + this.fieldName;
    }

    @Override
    public String toSetSourceString(OgnlContext context, Object target) {
        try {
            Object obj = OgnlRuntime.getStaticField(context, this.className, this.fieldName);
            context.setCurrentObject(obj);
            this._getterClass = this.getFieldClass(context);
            context.setCurrentType(this._getterClass);
        }
        catch (Throwable t2) {
            throw OgnlOps.castToRuntime(t2);
        }
        return this.className + "." + this.fieldName;
    }
}

