/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.shaded.com.ongres.scram.common.bouncycastle.pbkdf2;

import org.postgresql.shaded.com.ongres.scram.common.bouncycastle.pbkdf2.Arrays;
import org.postgresql.shaded.com.ongres.scram.common.bouncycastle.pbkdf2.CipherParameters;
import org.postgresql.shaded.com.ongres.scram.common.bouncycastle.pbkdf2.Digest;
import org.postgresql.shaded.com.ongres.scram.common.bouncycastle.pbkdf2.HMac;
import org.postgresql.shaded.com.ongres.scram.common.bouncycastle.pbkdf2.KeyParameter;
import org.postgresql.shaded.com.ongres.scram.common.bouncycastle.pbkdf2.Mac;
import org.postgresql.shaded.com.ongres.scram.common.bouncycastle.pbkdf2.PBEParametersGenerator;

public class PKCS5S2ParametersGenerator
extends PBEParametersGenerator {
    private Mac hMac;
    private byte[] state;

    public PKCS5S2ParametersGenerator(Digest digest) {
        this.hMac = new HMac(digest);
        this.state = new byte[this.hMac.getMacSize()];
    }

    private void F(byte[] S, int c2, byte[] iBuf, byte[] out, int outOff) {
        if (c2 == 0) {
            throw new IllegalArgumentException("iteration count must be at least 1.");
        }
        if (S != null) {
            this.hMac.update(S, 0, S.length);
        }
        this.hMac.update(iBuf, 0, iBuf.length);
        this.hMac.doFinal(this.state, 0);
        System.arraycopy(this.state, 0, out, outOff, this.state.length);
        for (int count = 1; count < c2; ++count) {
            this.hMac.update(this.state, 0, this.state.length);
            this.hMac.doFinal(this.state, 0);
            for (int j2 = 0; j2 != this.state.length; ++j2) {
                int n2 = outOff + j2;
                out[n2] = (byte)(out[n2] ^ this.state[j2]);
            }
        }
    }

    private byte[] generateDerivedKey(int dkLen) {
        int hLen = this.hMac.getMacSize();
        int l2 = (dkLen + hLen - 1) / hLen;
        byte[] iBuf = new byte[4];
        byte[] outBytes = new byte[l2 * hLen];
        int outPos = 0;
        KeyParameter param = new KeyParameter(this.password);
        this.hMac.init(param);
        for (int i2 = 1; i2 <= l2; ++i2) {
            int n2;
            int pos = 3;
            do {
                n2 = pos--;
            } while ((iBuf[n2] = (byte)(iBuf[n2] + 1)) == 0);
            this.F(this.salt, this.iterationCount, iBuf, outBytes, outPos);
            outPos += hLen;
        }
        return outBytes;
    }

    @Override
    public CipherParameters generateDerivedParameters(int keySize) {
        byte[] dKey = Arrays.copyOfRange(this.generateDerivedKey(keySize /= 8), 0, keySize);
        return new KeyParameter(dKey, 0, keySize);
    }
}

