/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.toolkit.sql;

import com.baomidou.mybatisplus.core.enums.SqlLike;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class SqlUtils
implements Constants {
    private static final Pattern pattern = Pattern.compile("\\{@((\\w+?)|(\\w+?:\\w+?)|(\\w+?:\\w+?:\\w+?))}");

    public static String concatLike(Object str, SqlLike type) {
        switch (type) {
            case LEFT: {
                return "%" + str;
            }
            case RIGHT: {
                return str + "%";
            }
        }
        return "%" + str + "%";
    }

    public static List<String> findPlaceholder(String sql) {
        Matcher matcher = pattern.matcher(sql);
        ArrayList<String> list = new ArrayList<String>();
        while (matcher.find()) {
            list.add(matcher.group());
        }
        return list;
    }

    public static String replaceSqlPlaceholder(String sql, List<String> placeHolder, String escapeSymbol) {
        for (String s2 : placeHolder) {
            String tableName;
            String s1 = s2.substring(2, s2.length() - 1);
            int i1 = s1.indexOf(":");
            String alisa = null;
            String asAlisa = null;
            if (i1 < 0) {
                tableName = s1;
            } else {
                tableName = s1.substring(0, i1);
                if ((i1 = (s1 = s1.substring(i1 + 1)).indexOf(":")) < 0) {
                    alisa = s1;
                } else {
                    alisa = s1.substring(0, i1);
                    asAlisa = s1.substring(i1 + 1);
                }
            }
            sql = sql.replace(s2, SqlUtils.getSelectBody(tableName, alisa, asAlisa, escapeSymbol));
        }
        return sql;
    }

    public static String getSelectBody(String tableName, String alisa, String asAlisa, String escapeSymbol) {
        TableInfo tableInfo = TableInfoHelper.getTableInfo(tableName);
        Assert.notNull(tableInfo, "can not find TableInfo Cache by \"%s\"", tableName);
        String s2 = tableInfo.chooseSelect(TableFieldInfo::isSelect);
        if (alisa == null) {
            return s2;
        }
        return SqlUtils.getNewSelectBody(s2, alisa, asAlisa, escapeSymbol);
    }

    public static String getNewSelectBody(String selectBody, String alisa, String asAlisa, String escapeSymbol) {
        String[] split = selectBody.split(",");
        StringBuilder sb = new StringBuilder();
        boolean asA = asAlisa != null;
        for (String body : split) {
            String sa = alisa.concat(".");
            if (asA) {
                int as = body.indexOf(" AS ");
                if (as < 0) {
                    sb.append(sa).append(body).append(" AS ").append(SqlUtils.escapeColumn(asAlisa.concat(".").concat(body), escapeSymbol));
                } else {
                    String column = body.substring(0, as);
                    String property = body.substring(as + 4);
                    property = StringUtils.getTargetColumn(property);
                    sb.append(sa).append(column).append(" AS ").append(SqlUtils.escapeColumn(asAlisa.concat(".").concat(property), escapeSymbol));
                }
            } else {
                sb.append(sa).append(body);
            }
            sb.append(",");
        }
        return sb.deleteCharAt(sb.length() - 1).toString();
    }

    private static String escapeColumn(String column, String escapeSymbol) {
        return escapeSymbol.concat(column).concat(escapeSymbol);
    }
}

