/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.config.builder;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.generator.ITemplate;
import com.baomidou.mybatisplus.generator.config.StrategyConfig;
import com.baomidou.mybatisplus.generator.config.builder.BaseBuilder;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.function.ConverterFileName;
import com.baomidou.mybatisplus.generator.util.ClassUtils;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Controller
implements ITemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(Controller.class);
    private boolean restStyle;
    private boolean hyphenStyle;
    private String superClass;
    private ConverterFileName converterFileName = entityName -> entityName + "Controller";
    private boolean fileOverride;

    private Controller() {
    }

    public boolean isRestStyle() {
        return this.restStyle;
    }

    public boolean isHyphenStyle() {
        return this.hyphenStyle;
    }

    @Nullable
    public String getSuperClass() {
        return this.superClass;
    }

    @NotNull
    public ConverterFileName getConverterFileName() {
        return this.converterFileName;
    }

    public boolean isFileOverride() {
        return this.fileOverride;
    }

    @Override
    @NotNull
    public Map<String, Object> renderData(@NotNull TableInfo tableInfo) {
        HashMap<String, Object> data = new HashMap<String, Object>(5);
        data.put("controllerMappingHyphen", StringUtils.camelToHyphen(tableInfo.getEntityPath()));
        data.put("controllerMappingHyphenStyle", this.hyphenStyle);
        data.put("restControllerStyle", this.restStyle);
        data.put("superControllerClassPackage", StringUtils.isBlank(this.superClass) ? null : this.superClass);
        data.put("superControllerClass", ClassUtils.getSimpleName(this.superClass));
        return data;
    }

    public static class Builder
    extends BaseBuilder {
        private final Controller controller = new Controller();

        public Builder(@NotNull StrategyConfig strategyConfig) {
            super(strategyConfig);
        }

        public Builder superClass(@NotNull Class<?> clazz) {
            return this.superClass(clazz.getName());
        }

        public Builder superClass(@NotNull String superClass) {
            this.controller.superClass = superClass;
            return this;
        }

        public Builder enableHyphenStyle() {
            this.controller.hyphenStyle = true;
            return this;
        }

        public Builder enableRestStyle() {
            this.controller.restStyle = true;
            return this;
        }

        public Builder convertFileName(@NotNull ConverterFileName converter) {
            this.controller.converterFileName = converter;
            return this;
        }

        public Builder formatFileName(@NotNull String format) {
            return this.convertFileName(entityName -> String.format(format, entityName));
        }

        @Deprecated
        public Builder fileOverride() {
            LOGGER.warn("fileOverride\u65b9\u6cd5\u540e\u7eed\u4f1a\u5220\u9664\uff0c\u66ff\u4ee3\u65b9\u6cd5\u4e3aenableFileOverride\u65b9\u6cd5");
            this.controller.fileOverride = true;
            return this;
        }

        public Builder enableFileOverride() {
            this.controller.fileOverride = true;
            return this;
        }

        @NotNull
        public Controller get() {
            return this.controller;
        }
    }
}

