/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.validation.validator;

import net.sf.jsqlparser.parser.feature.Feature;
import net.sf.jsqlparser.statement.create.table.CreateTable;
import net.sf.jsqlparser.statement.create.table.Index;
import net.sf.jsqlparser.util.validation.ValidationCapability;
import net.sf.jsqlparser.util.validation.metadata.NamedObject;
import net.sf.jsqlparser.util.validation.validator.AbstractValidator;
import net.sf.jsqlparser.util.validation.validator.StatementValidator;

public class CreateTableValidator
extends AbstractValidator<CreateTable> {
    @Override
    public void validate(CreateTable createTable) {
        for (ValidationCapability c2 : this.getCapabilities()) {
            this.validateFeature(c2, Feature.createTable);
            this.validateFeature(c2, createTable.isUnlogged(), Feature.createTableUnlogged);
            this.validateOptionalFeature(c2, createTable.getCreateOptionsStrings(), Feature.createTableCreateOptionStrings);
            this.validateOptionalFeature(c2, createTable.getTableOptionsStrings(), Feature.createTableTableOptionStrings);
            this.validateFeature(c2, createTable.isIfNotExists(), Feature.createTableIfNotExists);
            this.validateOptionalFeature(c2, createTable.getRowMovement(), Feature.createTableRowMovement);
            this.validateOptionalFeature(c2, createTable.getSelect(), Feature.createTableFromSelect);
            if (this.isNotEmpty(createTable.getIndexes())) {
                for (Index i2 : createTable.getIndexes()) {
                    this.validateName(c2, NamedObject.index, i2.getName());
                }
            }
            this.validateName(c2, NamedObject.table, createTable.getTable().getFullyQualifiedName(), false, new NamedObject[0]);
        }
        if (createTable.getSelect() != null) {
            this.getValidator(StatementValidator.class).validate(createTable.getSelect());
        }
    }
}

