/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.javassist.bytecode.annotation;

import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.ibatis.javassist.ClassPool;
import org.apache.ibatis.javassist.bytecode.ConstPool;
import org.apache.ibatis.javassist.bytecode.annotation.AnnotationsWriter;
import org.apache.ibatis.javassist.bytecode.annotation.MemberValue;
import org.apache.ibatis.javassist.bytecode.annotation.MemberValueVisitor;

public class ArrayMemberValue
extends MemberValue {
    MemberValue type;
    MemberValue[] values;

    public ArrayMemberValue(ConstPool cp) {
        super('[', cp);
        this.type = null;
        this.values = null;
    }

    public ArrayMemberValue(MemberValue t2, ConstPool cp) {
        super('[', cp);
        this.type = t2;
        this.values = null;
    }

    @Override
    Object getValue(ClassLoader cl, ClassPool cp, Method method) throws ClassNotFoundException {
        Class<?> clazz;
        if (this.values == null) {
            throw new ClassNotFoundException("no array elements found: " + method.getName());
        }
        int size = this.values.length;
        if (this.type == null) {
            clazz = method.getReturnType().getComponentType();
            if (clazz == null || size > 0) {
                throw new ClassNotFoundException("broken array type: " + method.getName());
            }
        } else {
            clazz = this.type.getType(cl);
        }
        Object a2 = Array.newInstance(clazz, size);
        for (int i2 = 0; i2 < size; ++i2) {
            Array.set(a2, i2, this.values[i2].getValue(cl, cp, method));
        }
        return a2;
    }

    @Override
    Class<?> getType(ClassLoader cl) throws ClassNotFoundException {
        if (this.type == null) {
            throw new ClassNotFoundException("no array type specified");
        }
        Object a2 = Array.newInstance(this.type.getType(cl), 0);
        return a2.getClass();
    }

    @Override
    public void renameClass(String oldname, String newname) {
        if (this.type != null) {
            this.type.renameClass(oldname, newname);
        }
        if (this.values != null) {
            for (MemberValue value : this.values) {
                value.renameClass(oldname, newname);
            }
        }
    }

    @Override
    public void renameClass(Map<String, String> classnames) {
        if (this.type != null) {
            this.type.renameClass(classnames);
        }
        if (this.values != null) {
            for (MemberValue value : this.values) {
                value.renameClass(classnames);
            }
        }
    }

    public MemberValue getType() {
        return this.type;
    }

    public MemberValue[] getValue() {
        return this.values;
    }

    public void setValue(MemberValue[] elements) {
        this.values = elements;
        if (elements != null && elements.length > 0) {
            this.type = elements[0];
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('{');
        if (this.values != null) {
            for (int i2 = 0; i2 < this.values.length; ++i2) {
                buf.append(this.values[i2].toString());
                if (i2 + 1 >= this.values.length) continue;
                buf.append(", ");
            }
        }
        buf.append('}');
        return buf.toString();
    }

    @Override
    public void write(AnnotationsWriter writer) throws IOException {
        int num = this.values == null ? 0 : this.values.length;
        writer.arrayValue(num);
        for (int i2 = 0; i2 < num; ++i2) {
            this.values[i2].write(writer);
        }
    }

    @Override
    public void accept(MemberValueVisitor visitor) {
        visitor.visitArrayMemberValue(this);
    }
}

