/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.comparator;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;

public class NullComparator<T>
implements Comparator<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final boolean nullGreater;
    protected final Comparator<T> comparator;

    public NullComparator(boolean nullGreater, Comparator<? super T> comparator) {
        this.nullGreater = nullGreater;
        this.comparator = comparator;
    }

    @Override
    public int compare(T a2, T b2) {
        if (a2 == b2) {
            return 0;
        }
        if (a2 == null) {
            return this.nullGreater ? 1 : -1;
        }
        if (b2 == null) {
            return this.nullGreater ? -1 : 1;
        }
        return this.doCompare(a2, b2);
    }

    @Override
    public Comparator<T> thenComparing(Comparator<? super T> other) {
        Objects.requireNonNull(other);
        return new NullComparator<T>(this.nullGreater, this.comparator == null ? other : this.comparator.thenComparing(other));
    }

    @Override
    public Comparator<T> reversed() {
        return new NullComparator<T>(false == this.nullGreater, this.comparator == null ? null : this.comparator.reversed());
    }

    protected int doCompare(T a2, T b2) {
        if (null == this.comparator) {
            if (a2 instanceof Comparable && b2 instanceof Comparable) {
                return ((Comparable)a2).compareTo(b2);
            }
            return 0;
        }
        return this.comparator.compare(a2, b2);
    }
}

