/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.io;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.ArrayUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;

public class CharsetDetector {
    private static final Charset[] DEFAULT_CHARSETS;

    public static Charset detect(File file, Charset ... charsets) {
        return CharsetDetector.detect(FileUtil.getInputStream(file), charsets);
    }

    public static Charset detect(InputStream in, Charset ... charsets) {
        return CharsetDetector.detect(32768, in, charsets);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Charset detect(int bufferSize, InputStream in, Charset ... charsets) {
        if (ArrayUtil.isEmpty(charsets)) {
            charsets = DEFAULT_CHARSETS;
        }
        byte[] buffer = new byte[bufferSize];
        try {
            block6: while (true) {
                if (in.read(buffer) <= -1) return null;
                Charset[] charsetArray = charsets;
                int n2 = charsetArray.length;
                int n3 = 0;
                while (true) {
                    if (n3 >= n2) continue block6;
                    Charset charset = charsetArray[n3];
                    CharsetDecoder decoder = charset.newDecoder();
                    if (CharsetDetector.identify(buffer, decoder)) {
                        Charset charset2 = charset;
                        return charset2;
                    }
                    ++n3;
                }
                break;
            }
        }
        catch (IOException e2) {
            throw new IORuntimeException(e2);
        }
        finally {
            IoUtil.close(in);
        }
    }

    private static boolean identify(byte[] bytes, CharsetDecoder decoder) {
        try {
            decoder.decode(ByteBuffer.wrap(bytes));
        }
        catch (CharacterCodingException e2) {
            return false;
        }
        return true;
    }

    static {
        String[] names = new String[]{"UTF-8", "GBK", "GB2312", "GB18030", "UTF-16BE", "UTF-16LE", "UTF-16", "BIG5", "UNICODE", "US-ASCII"};
        DEFAULT_CHARSETS = Convert.convert(Charset[].class, (Object)names);
    }
}

