/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.net;

import cn.hutool.core.codec.PercentCodec;

public class RFC3986 {
    public static final PercentCodec GEN_DELIMS = PercentCodec.of(":/?#[]@");
    public static final PercentCodec SUB_DELIMS = PercentCodec.of("!$&'()*+,;=");
    public static final PercentCodec RESERVED = GEN_DELIMS.orNew(SUB_DELIMS);
    public static final PercentCodec UNRESERVED = PercentCodec.of(RFC3986.unreservedChars());
    public static final PercentCodec PCHAR;
    public static final PercentCodec SEGMENT;
    public static final PercentCodec SEGMENT_NZ_NC;
    public static final PercentCodec PATH;
    public static final PercentCodec QUERY;
    public static final PercentCodec FRAGMENT;
    public static final PercentCodec QUERY_PARAM_VALUE;
    public static final PercentCodec QUERY_PARAM_NAME;

    private static StringBuilder unreservedChars() {
        char c2;
        StringBuilder sb = new StringBuilder();
        for (c2 = 'A'; c2 <= 'Z'; c2 = (char)(c2 + '\u0001')) {
            sb.append(c2);
        }
        for (c2 = 'a'; c2 <= 'z'; c2 = (char)(c2 + '\u0001')) {
            sb.append(c2);
        }
        for (c2 = '0'; c2 <= '9'; c2 = (char)(c2 + '\u0001')) {
            sb.append(c2);
        }
        sb.append("_.-~");
        return sb;
    }

    static {
        SEGMENT = PCHAR = UNRESERVED.orNew(SUB_DELIMS).or(PercentCodec.of(":@"));
        SEGMENT_NZ_NC = PercentCodec.of(SEGMENT).removeSafe(':');
        PATH = SEGMENT.orNew(PercentCodec.of("/"));
        FRAGMENT = QUERY = PCHAR.orNew(PercentCodec.of("/?"));
        QUERY_PARAM_VALUE = PercentCodec.of(QUERY).removeSafe('&');
        QUERY_PARAM_NAME = PercentCodec.of(QUERY_PARAM_VALUE).removeSafe('=');
    }
}

