/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.poi.excel.reader;

import cn.hutool.poi.excel.cell.CellUtil;
import cn.hutool.poi.excel.reader.AbstractSheetReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.Sheet;

public class ColumnSheetReader
extends AbstractSheetReader<List<Object>> {
    private final int columnIndex;

    public ColumnSheetReader(int columnIndex, int startRowIndex, int endRowIndex) {
        super(startRowIndex, endRowIndex);
        this.columnIndex = columnIndex;
    }

    @Override
    public List<Object> read(Sheet sheet) {
        ArrayList<Object> resultList = new ArrayList<Object>();
        int startRowIndex = Math.max(this.startRowIndex, sheet.getFirstRowNum());
        int endRowIndex = Math.min(this.endRowIndex, sheet.getLastRowNum());
        for (int i2 = startRowIndex; i2 <= endRowIndex; ++i2) {
            Object value = CellUtil.getCellValue(CellUtil.getCell(sheet.getRow(i2), this.columnIndex), this.cellEditor);
            if (null == value && this.ignoreEmptyRow) continue;
            resultList.add(value);
        }
        return resultList;
    }
}

