/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.query;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.generator.config.builder.ConfigBuilder;
import com.baomidou.mybatisplus.generator.config.builder.Entity;
import com.baomidou.mybatisplus.generator.config.po.TableField;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.config.rules.IColumnType;
import com.baomidou.mybatisplus.generator.jdbc.DatabaseMetaDataWrapper;
import com.baomidou.mybatisplus.generator.query.AbstractDatabaseQuery;
import com.baomidou.mybatisplus.generator.type.ITypeConvertHandler;
import com.baomidou.mybatisplus.generator.type.TypeRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DefaultQuery
extends AbstractDatabaseQuery {
    private final TypeRegistry typeRegistry;
    protected final DatabaseMetaDataWrapper databaseMetaDataWrapper;

    public DefaultQuery(@NotNull ConfigBuilder configBuilder) {
        super(configBuilder);
        this.typeRegistry = new TypeRegistry(configBuilder.getGlobalConfig());
        this.databaseMetaDataWrapper = new DatabaseMetaDataWrapper(this.dataSourceConfig.getConn(), this.dataSourceConfig.getSchemaName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<TableInfo> queryTables() {
        try {
            boolean isInclude = this.strategyConfig.getInclude().size() > 0;
            boolean isExclude = this.strategyConfig.getExclude().size() > 0;
            ArrayList<TableInfo> tableList = new ArrayList<TableInfo>();
            List<DatabaseMetaDataWrapper.Table> tables = this.getTables();
            ArrayList<TableInfo> includeTableList = new ArrayList<TableInfo>();
            ArrayList<TableInfo> excludeTableList = new ArrayList<TableInfo>();
            tables.forEach(table -> {
                String tableName = table.getName();
                if (StringUtils.isNotBlank(tableName)) {
                    TableInfo tableInfo = new TableInfo(this.configBuilder, tableName);
                    tableInfo.setComment(table.getRemarks());
                    if (isInclude && this.strategyConfig.matchIncludeTable(tableName)) {
                        includeTableList.add(tableInfo);
                    } else if (isExclude && this.strategyConfig.matchExcludeTable(tableName)) {
                        excludeTableList.add(tableInfo);
                    }
                    tableList.add(tableInfo);
                }
            });
            this.filter(tableList, includeTableList, excludeTableList);
            tableList.forEach(this::convertTableFields);
            ArrayList<TableInfo> arrayList = tableList;
            return arrayList;
        }
        finally {
            this.databaseMetaDataWrapper.closeConnection();
        }
    }

    protected List<DatabaseMetaDataWrapper.Table> getTables() {
        String[] stringArray;
        boolean skipView = this.strategyConfig.isSkipView();
        String tableNamePattern = null;
        if (this.strategyConfig.getLikeTable() != null) {
            tableNamePattern = this.strategyConfig.getLikeTable().getValue();
        }
        if (skipView) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "TABLE";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "TABLE";
            stringArray = stringArray3;
            stringArray3[1] = "VIEW";
        }
        return this.databaseMetaDataWrapper.getTables(tableNamePattern, stringArray);
    }

    protected void convertTableFields(@NotNull TableInfo tableInfo) {
        String tableName = tableInfo.getName();
        Map<String, DatabaseMetaDataWrapper.Column> columnsInfoMap = this.getColumnsInfo(tableName);
        Entity entity = this.strategyConfig.entity();
        columnsInfoMap.forEach((k2, columnInfo) -> {
            String columnName = columnInfo.getName();
            TableField field = new TableField(this.configBuilder, columnName);
            if (columnInfo.isPrimaryKey()) {
                field.primaryKey(columnInfo.isAutoIncrement());
                tableInfo.setHavePrimaryKey(true);
                if (field.isKeyIdentityFlag() && entity.getIdType() != null) {
                    this.LOGGER.warn("\u5f53\u524d\u8868[{}]\u7684\u4e3b\u952e\u4e3a\u81ea\u589e\u4e3b\u952e\uff0c\u4f1a\u5bfc\u81f4\u5168\u5c40\u4e3b\u952e\u7684ID\u7c7b\u578b\u8bbe\u7f6e\u5931\u6548!", (Object)tableName);
                }
            }
            field.setColumnName(columnName).setComment(columnInfo.getRemarks());
            String propertyName = entity.getNameConvert().propertyNameConvert(field);
            TableField.MetaInfo metaInfo = new TableField.MetaInfo((DatabaseMetaDataWrapper.Column)columnInfo, tableInfo);
            IColumnType columnType = this.typeRegistry.getColumnType(metaInfo);
            ITypeConvertHandler typeConvertHandler = this.dataSourceConfig.getTypeConvertHandler();
            if (typeConvertHandler != null) {
                columnType = typeConvertHandler.convert(this.globalConfig, this.typeRegistry, metaInfo);
            }
            field.setPropertyName(propertyName, columnType);
            field.setMetaInfo(metaInfo);
            tableInfo.addField(field);
        });
        tableInfo.processTable();
    }

    protected Map<String, DatabaseMetaDataWrapper.Column> getColumnsInfo(String tableName) {
        return this.databaseMetaDataWrapper.getColumnsInfo(tableName, true);
    }
}

