/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.jsp;

import freemarker.template.utility.ClassUtil;
import freemarker.template.utility.StringUtil;
import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class TaglibMethodUtil {
    private static final Pattern FUNCTION_SIGNATURE_PATTERN = Pattern.compile("^([\\w\\.]+(\\s*\\[\\s*\\])?)\\s+(\\w+)\\s*\\((.*)\\)$", 32);
    private static final Pattern FUNCTION_PARAMETER_PATTERN = Pattern.compile("^([\\w\\.]+)(\\s*\\[\\s*\\])?$");

    private TaglibMethodUtil() {
    }

    static Method getMethodByFunctionSignature(Class clazz, String signature) throws SecurityException, NoSuchMethodException, ClassNotFoundException {
        Matcher m1 = FUNCTION_SIGNATURE_PATTERN.matcher(signature);
        if (!m1.matches()) {
            throw new IllegalArgumentException("Invalid function signature (doesn't match this pattern: " + FUNCTION_SIGNATURE_PATTERN + ")");
        }
        String methodName = m1.group(3);
        String params = m1.group(4).trim();
        Class[] paramTypes = null;
        if ("".equals(params)) {
            paramTypes = new Class[]{};
        } else {
            String[] paramsArray = StringUtil.split(params, ',');
            paramTypes = new Class[paramsArray.length];
            String token = null;
            String paramType = null;
            boolean isPrimitive = false;
            boolean isArrayType = false;
            Matcher m22 = null;
            for (int i2 = 0; i2 < paramsArray.length; ++i2) {
                token = paramsArray[i2].trim();
                m22 = FUNCTION_PARAMETER_PATTERN.matcher(token);
                if (!m22.matches()) {
                    throw new IllegalArgumentException("Invalid argument signature (doesn't match pattern " + FUNCTION_PARAMETER_PATTERN + "): " + token);
                }
                paramType = m22.group(1);
                isPrimitive = paramType.indexOf(46) == -1;
                boolean bl = isArrayType = m22.group(2) != null;
                if (isPrimitive) {
                    if ("byte".equals(paramType)) {
                        paramTypes[i2] = isArrayType ? byte[].class : Byte.TYPE;
                        continue;
                    }
                    if ("short".equals(paramType)) {
                        paramTypes[i2] = isArrayType ? short[].class : Short.TYPE;
                        continue;
                    }
                    if ("int".equals(paramType)) {
                        paramTypes[i2] = isArrayType ? int[].class : Integer.TYPE;
                        continue;
                    }
                    if ("long".equals(paramType)) {
                        paramTypes[i2] = isArrayType ? long[].class : Long.TYPE;
                        continue;
                    }
                    if ("float".equals(paramType)) {
                        paramTypes[i2] = isArrayType ? float[].class : Float.TYPE;
                        continue;
                    }
                    if ("double".equals(paramType)) {
                        paramTypes[i2] = isArrayType ? double[].class : Double.TYPE;
                        continue;
                    }
                    if ("boolean".equals(paramType)) {
                        paramTypes[i2] = isArrayType ? boolean[].class : Boolean.TYPE;
                        continue;
                    }
                    if ("char".equals(paramType)) {
                        paramTypes[i2] = isArrayType ? char[].class : Character.TYPE;
                        continue;
                    }
                    throw new IllegalArgumentException("Invalid primitive type: '" + paramType + "'.");
                }
                paramTypes[i2] = isArrayType ? ClassUtil.forName("[L" + paramType + ";") : ClassUtil.forName(paramType);
            }
        }
        return clazz.getMethod(methodName, paramTypes);
    }
}

