/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.UserVariable;
import net.sf.jsqlparser.statement.DeclareType;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;
import net.sf.jsqlparser.statement.create.table.ColDataType;
import net.sf.jsqlparser.statement.create.table.ColumnDefinition;

public final class DeclareStatement
implements Statement {
    private UserVariable userVariable = null;
    private DeclareType declareType = DeclareType.TYPE;
    private String typeName;
    private List<TypeDefExpr> typeDefExprList = new ArrayList<TypeDefExpr>();
    private List<ColumnDefinition> columnDefinitions = new ArrayList<ColumnDefinition>();

    public void setUserVariable(UserVariable userVariable) {
        this.userVariable = userVariable;
    }

    public UserVariable getUserVariable() {
        return this.userVariable;
    }

    @Deprecated
    public DeclareType getType() {
        return this.getDeclareType();
    }

    public DeclareType getDeclareType() {
        return this.declareType;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setDeclareType(DeclareType declareType) {
        this.declareType = declareType;
    }

    public void addType(ColDataType colDataType, Expression defaultExpr) {
        this.addTypeDefExprList(new TypeDefExpr(colDataType, defaultExpr));
    }

    public void addType(UserVariable userVariable, ColDataType colDataType, Expression defaultExpr) {
        this.addTypeDefExprList(new TypeDefExpr(userVariable, colDataType, defaultExpr));
    }

    public DeclareStatement addTypeDefExprList(TypeDefExpr ... typeDefExpressions) {
        List collection = Optional.ofNullable(this.getTypeDefExprList()).orElseGet(ArrayList::new);
        Collections.addAll(collection, typeDefExpressions);
        return this.withTypeDefExprList(collection);
    }

    public DeclareStatement addTypeDefExprList(Collection<? extends TypeDefExpr> typeDefExpressions) {
        List collection = Optional.ofNullable(this.getTypeDefExprList()).orElseGet(ArrayList::new);
        collection.addAll(typeDefExpressions);
        return this.withTypeDefExprList(collection);
    }

    public DeclareStatement withTypeDefExprList(List<TypeDefExpr> typeDefExpressions) {
        this.setTypeDefExprList(typeDefExpressions);
        return this;
    }

    public void setTypeDefExprList(List<TypeDefExpr> expr) {
        this.typeDefExprList = expr;
    }

    public List<TypeDefExpr> getTypeDefExprList() {
        return this.typeDefExprList;
    }

    public void addColumnDefinition(ColumnDefinition colDef) {
        this.columnDefinitions.add(colDef);
    }

    public void setColumnDefinitions(List<ColumnDefinition> columnDefinitions) {
        this.columnDefinitions = columnDefinitions;
    }

    public List<ColumnDefinition> getColumnDefinitions() {
        return this.columnDefinitions;
    }

    public List<TypeDefExpr> getTypeDefinitions() {
        return this.typeDefExprList;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String toString() {
        StringBuilder b2 = new StringBuilder("DECLARE ");
        if (this.declareType == DeclareType.AS) {
            b2.append(this.userVariable.toString());
            b2.append(" AS ").append(this.typeName);
        } else if (this.declareType == DeclareType.TABLE) {
            b2.append(this.userVariable.toString());
            b2.append(" TABLE (");
            for (int i2 = 0; i2 < this.columnDefinitions.size(); ++i2) {
                if (i2 > 0) {
                    b2.append(", ");
                }
                b2.append(this.columnDefinitions.get(i2).toString());
            }
            b2.append(")");
        } else {
            for (int i3 = 0; i3 < this.typeDefExprList.size(); ++i3) {
                if (i3 > 0) {
                    b2.append(", ");
                }
                TypeDefExpr type = this.typeDefExprList.get(i3);
                if (type.userVariable != null) {
                    b2.append(type.userVariable.toString()).append(" ");
                }
                b2.append(type.colDataType.toString());
                if (type.defaultExpr == null) continue;
                b2.append(" = ").append(type.defaultExpr.toString());
            }
        }
        return b2.toString();
    }

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public DeclareStatement withUserVariable(UserVariable userVariable) {
        this.setUserVariable(userVariable);
        return this;
    }

    public DeclareStatement withTypeName(String typeName) {
        this.setTypeName(typeName);
        return this;
    }

    public DeclareStatement withDeclareType(DeclareType declareType) {
        this.setDeclareType(declareType);
        return this;
    }

    public DeclareStatement withColumnDefinitions(List<ColumnDefinition> columnDefinitions) {
        this.setColumnDefinitions(columnDefinitions);
        return this;
    }

    public DeclareStatement addColumnDefinitions(ColumnDefinition ... statements) {
        List collection = Optional.ofNullable(this.getColumnDefinitions()).orElseGet(ArrayList::new);
        Collections.addAll(collection, statements);
        return this.withColumnDefinitions(collection);
    }

    public DeclareStatement addColumnDefinitions(Collection<? extends ColumnDefinition> columnDefinitions) {
        List collection = Optional.ofNullable(this.getColumnDefinitions()).orElseGet(ArrayList::new);
        collection.addAll(columnDefinitions);
        return this.withColumnDefinitions(collection);
    }

    public static class TypeDefExpr {
        public final UserVariable userVariable;
        public final ColDataType colDataType;
        public final Expression defaultExpr;

        public TypeDefExpr(ColDataType colDataType, Expression defaultExpr) {
            this(null, colDataType, defaultExpr);
        }

        public TypeDefExpr(UserVariable userVariable, ColDataType colDataType, Expression defaultExpr) {
            this.userVariable = userVariable;
            this.colDataType = colDataType;
            this.defaultExpr = defaultExpr;
        }
    }
}

