/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.validation.validator;

import java.util.List;
import java.util.stream.Collectors;
import net.sf.jsqlparser.parser.feature.Feature;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.update.Update;
import net.sf.jsqlparser.util.validation.ValidationCapability;
import net.sf.jsqlparser.util.validation.validator.AbstractValidator;
import net.sf.jsqlparser.util.validation.validator.LimitValidator;
import net.sf.jsqlparser.util.validation.validator.SelectValidator;

public class UpdateValidator
extends AbstractValidator<Update> {
    @Override
    public void validate(Update update) {
        for (ValidationCapability c2 : this.getCapabilities()) {
            this.validateFeature(c2, Feature.update);
            this.validateOptionalFeature(c2, update.getFromItem(), Feature.updateFrom);
            this.validateOptionalFeature(c2, update.getStartJoins(), Feature.updateJoins);
            this.validateFeature(c2, update.isUseSelect(), Feature.updateUseSelect);
            this.validateOptionalFeature(c2, update.getOrderByElements(), Feature.updateOrderBy);
            this.validateOptionalFeature(c2, update.getLimit(), Feature.updateLimit);
            if (!this.isNotEmpty(update.getReturningExpressionList()) && !update.isReturningAllColumns()) continue;
            this.validateFeature(c2, Feature.updateReturning);
        }
        this.validateOptionalFromItem(update.getTable());
        this.validateOptional(update.getStartJoins(), j2 -> this.getValidator(SelectValidator.class).validateOptionalJoins((List<Join>)j2));
        if (update.isUseSelect()) {
            this.validateOptionalExpressions(update.getColumns());
            this.validateOptional(update.getSelect(), e2 -> e2.getSelectBody().accept(this.getValidator(SelectValidator.class)));
        } else {
            this.validateOptionalExpressions(update.getColumns());
            this.validateOptionalExpressions(update.getExpressions());
        }
        if (update.getFromItem() != null) {
            this.validateOptionalFromItem(update.getFromItem());
            this.validateOptional(update.getJoins(), j2 -> this.getValidator(SelectValidator.class).validateOptionalJoins((List<Join>)j2));
        }
        this.validateOptionalExpression(update.getWhere());
        this.validateOptionalOrderByElements(update.getOrderByElements());
        if (update.getLimit() != null) {
            this.getValidator(LimitValidator.class).validate(update.getLimit());
        }
        if (update.getReturningExpressionList() != null) {
            this.validateOptionalExpressions(update.getReturningExpressionList().stream().map(SelectExpressionItem::getExpression).collect(Collectors.toList()));
        }
    }
}

