/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.validation.validator;

import net.sf.jsqlparser.parser.feature.Feature;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.upsert.Upsert;
import net.sf.jsqlparser.util.validation.ValidationCapability;
import net.sf.jsqlparser.util.validation.validator.AbstractValidator;
import net.sf.jsqlparser.util.validation.validator.SelectValidator;

public class UpsertValidator
extends AbstractValidator<Upsert> {
    @Override
    public void validate(Upsert upsert) {
        for (ValidationCapability c2 : this.getCapabilities()) {
            this.validateFeature(c2, Feature.upsert);
        }
        this.validateOptionalFromItem(upsert.getTable());
        this.validateOptionalExpressions(upsert.getColumns());
        this.validateOptionalItemsList(upsert.getItemsList());
        this.validateOptionalSelect(upsert.getSelect());
        if (upsert.isUseDuplicate()) {
            this.validateDuplicate(upsert);
        }
    }

    private void validateOptionalSelect(Select select) {
        if (select != null) {
            SelectValidator v2 = this.getValidator(SelectValidator.class);
            if (this.isNotEmpty(select.getWithItemsList())) {
                select.getWithItemsList().forEach(with -> with.accept(v2));
            }
            select.getSelectBody().accept(v2);
        }
    }

    private void validateDuplicate(Upsert upsert) {
        this.validateOptionalExpressions(upsert.getDuplicateUpdateColumns());
        this.validateOptionalExpressions(upsert.getDuplicateUpdateExpressionList());
    }
}

