/*
 * Decompiled with CFR 0.152.
 */
package top.tanmw.generator.db;

import cn.hutool.core.util.StrUtil;
import top.tanmw.generator.db.DbQuery;
import top.tanmw.generator.db.DbType;
import top.tanmw.generator.db.DmQuery;
import top.tanmw.generator.db.KingbaseQuery;
import top.tanmw.generator.db.MysqlQuery;
import top.tanmw.generator.db.OracleQuery;
import top.tanmw.generator.db.PgSqlQuery;

public class DbFactory {
    public static DbQuery getDbQuery(String url) {
        String dbName = DbFactory.getDbName(url);
        DbType dbType = DbFactory.getDbType(url);
        switch (dbType) {
            case ORACLE: {
                return new OracleQuery(dbName);
            }
            case MYSQL: {
                return new MysqlQuery(dbName);
            }
            case POSTGRESQL: {
                return new PgSqlQuery(dbName);
            }
            case KINGBASE: {
                return new KingbaseQuery(dbName);
            }
            case DM: {
                return new DmQuery(dbName);
            }
        }
        throw new RuntimeException("\u9a71\u52a8\u7c7b\u578b\u65e0\u6cd5\u8bc6\u522b\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u8005");
    }

    public static DbType getDbType(String url) {
        if (StrUtil.contains((CharSequence)url, "jdbc:oracle")) {
            return DbType.ORACLE;
        }
        if (StrUtil.contains((CharSequence)url, "jdbc:mysql")) {
            return DbType.MYSQL;
        }
        if (StrUtil.contains((CharSequence)url, "jdbc:postgresql")) {
            return DbType.POSTGRESQL;
        }
        if (StrUtil.contains((CharSequence)url, "jdbc:kingbase")) {
            return DbType.KINGBASE;
        }
        if (StrUtil.contains((CharSequence)url, "jdbc:dm")) {
            return DbType.DM;
        }
        return DbType.UNKNOW;
    }

    public static String getDbName(String url) {
        int indexOf1 = url.lastIndexOf("/");
        int indexOf2 = url.indexOf("?");
        if (indexOf2 < 0) {
            return url.substring(indexOf1 + 1);
        }
        return url.substring(indexOf1 + 1, indexOf2);
    }
}

