/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template.utility;

import freemarker.core.Environment;
import freemarker.core.ParseException;
import freemarker.ext.dom._ExtDomApi;
import freemarker.template.Version;
import freemarker.template.utility.ClassUtil;
import freemarker.template.utility.CollectionUtils;
import freemarker.template.utility.NullArgumentException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class StringUtil {
    private static final char[] ESCAPES = StringUtil.createEscapes();
    private static final char[] LT = new char[]{'&', 'l', 't', ';'};
    private static final char[] GT = new char[]{'&', 'g', 't', ';'};
    private static final char[] AMP = new char[]{'&', 'a', 'm', 'p', ';'};
    private static final char[] QUOT = new char[]{'&', 'q', 'u', 'o', 't', ';'};
    private static final char[] HTML_APOS = new char[]{'&', '#', '3', '9', ';'};
    private static final char[] XML_APOS = new char[]{'&', 'a', 'p', 'o', 's', ';'};
    private static final int NO_ESC = 0;
    private static final int ESC_HEXA = 1;
    private static final int ESC_BACKSLASH = 3;

    @Deprecated
    public static String HTMLEnc(String s2) {
        return StringUtil.XMLEncNA(s2);
    }

    public static String XMLEnc(String s2) {
        return StringUtil.XMLOrHTMLEnc(s2, true, true, XML_APOS);
    }

    public static void XMLEnc(String s2, Writer out) throws IOException {
        StringUtil.XMLOrHTMLEnc(s2, XML_APOS, out);
    }

    public static String XHTMLEnc(String s2) {
        return StringUtil.XMLOrHTMLEnc(s2, true, true, HTML_APOS);
    }

    public static void XHTMLEnc(String s2, Writer out) throws IOException {
        StringUtil.XMLOrHTMLEnc(s2, HTML_APOS, out);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String XMLOrHTMLEnc(String s2, boolean escGT, boolean escQuot, char[] apos) {
        int ln = s2.length();
        int firstEscIdx = -1;
        int lastEscIdx = 0;
        int plusOutLn = 0;
        block14: for (int i2 = 0; i2 < ln; ++i2) {
            char c2 = s2.charAt(i2);
            switch (c2) {
                case '<': {
                    plusOutLn += LT.length - 1;
                    break;
                }
                case '>': {
                    if (!escGT && !StringUtil.maybeCDataEndGT(s2, i2)) continue block14;
                    plusOutLn += GT.length - 1;
                    break;
                }
                case '&': {
                    plusOutLn += AMP.length - 1;
                    break;
                }
                case '\"': {
                    if (!escQuot) continue block14;
                    plusOutLn += QUOT.length - 1;
                    break;
                }
                case '\'': {
                    if (apos == null) continue block14;
                    plusOutLn += apos.length - 1;
                    break;
                }
                default: {
                    continue block14;
                }
            }
            if (firstEscIdx == -1) {
                firstEscIdx = i2;
            }
            lastEscIdx = i2;
        }
        if (firstEscIdx == -1) {
            return s2;
        }
        char[] esced = new char[ln + plusOutLn];
        if (firstEscIdx != 0) {
            s2.getChars(0, firstEscIdx, esced, 0);
        }
        int dst = firstEscIdx;
        block15: for (int i3 = firstEscIdx; i3 <= lastEscIdx; ++i3) {
            char c3 = s2.charAt(i3);
            switch (c3) {
                case '<': {
                    dst = StringUtil.shortArrayCopy(LT, esced, dst);
                    continue block15;
                }
                case '>': {
                    if (!escGT && !StringUtil.maybeCDataEndGT(s2, i3)) break;
                    dst = StringUtil.shortArrayCopy(GT, esced, dst);
                    continue block15;
                }
                case '&': {
                    dst = StringUtil.shortArrayCopy(AMP, esced, dst);
                    continue block15;
                }
                case '\"': {
                    if (!escQuot) break;
                    dst = StringUtil.shortArrayCopy(QUOT, esced, dst);
                    continue block15;
                }
                case '\'': {
                    if (apos == null) break;
                    dst = StringUtil.shortArrayCopy(apos, esced, dst);
                    continue block15;
                }
            }
            esced[dst++] = c3;
        }
        if (lastEscIdx != ln - 1) {
            s2.getChars(lastEscIdx + 1, ln, esced, dst);
        }
        return String.valueOf(esced);
    }

    private static boolean maybeCDataEndGT(String s2, int i2) {
        if (i2 == 0) {
            return true;
        }
        if (s2.charAt(i2 - 1) != ']') {
            return false;
        }
        return i2 == 1 || s2.charAt(i2 - 2) == ']';
    }

    private static void XMLOrHTMLEnc(String s2, char[] apos, Writer out) throws IOException {
        int writtenEnd = 0;
        int ln = s2.length();
        block6: for (int i2 = 0; i2 < ln; ++i2) {
            char c2 = s2.charAt(i2);
            if (c2 != '<' && c2 != '>' && c2 != '&' && c2 != '\"' && c2 != '\'') continue;
            int flushLn = i2 - writtenEnd;
            if (flushLn != 0) {
                out.write(s2, writtenEnd, flushLn);
            }
            writtenEnd = i2 + 1;
            switch (c2) {
                case '<': {
                    out.write(LT);
                    continue block6;
                }
                case '>': {
                    out.write(GT);
                    continue block6;
                }
                case '&': {
                    out.write(AMP);
                    continue block6;
                }
                case '\"': {
                    out.write(QUOT);
                    continue block6;
                }
                default: {
                    out.write(apos);
                }
            }
        }
        if (writtenEnd < ln) {
            out.write(s2, writtenEnd, ln - writtenEnd);
        }
    }

    private static int shortArrayCopy(char[] src, char[] dst, int dstOffset) {
        for (char dst[dstOffset++] : src) {
        }
        return dstOffset;
    }

    public static String XMLEncNA(String s2) {
        return StringUtil.XMLOrHTMLEnc(s2, true, true, null);
    }

    public static String XMLEncQAttr(String s2) {
        return StringUtil.XMLOrHTMLEnc(s2, false, true, null);
    }

    public static String XMLEncNQG(String s2) {
        return StringUtil.XMLOrHTMLEnc(s2, false, false, null);
    }

    public static String RTFEnc(String s2) {
        int ln = s2.length();
        int firstEscIdx = -1;
        int lastEscIdx = 0;
        int plusOutLn = 0;
        for (int i2 = 0; i2 < ln; ++i2) {
            char c2 = s2.charAt(i2);
            if (c2 != '{' && c2 != '}' && c2 != '\\') continue;
            if (firstEscIdx == -1) {
                firstEscIdx = i2;
            }
            lastEscIdx = i2;
            ++plusOutLn;
        }
        if (firstEscIdx == -1) {
            return s2;
        }
        char[] esced = new char[ln + plusOutLn];
        if (firstEscIdx != 0) {
            s2.getChars(0, firstEscIdx, esced, 0);
        }
        int dst = firstEscIdx;
        for (int i3 = firstEscIdx; i3 <= lastEscIdx; ++i3) {
            char c3 = s2.charAt(i3);
            if (c3 == '{' || c3 == '}' || c3 == '\\') {
                esced[dst++] = 92;
            }
            esced[dst++] = c3;
        }
        if (lastEscIdx != ln - 1) {
            s2.getChars(lastEscIdx + 1, ln, esced, dst);
        }
        return String.valueOf(esced);
    }

    public static void RTFEnc(String s2, Writer out) throws IOException {
        int writtenEnd = 0;
        int ln = s2.length();
        for (int i2 = 0; i2 < ln; ++i2) {
            char c2 = s2.charAt(i2);
            if (c2 != '{' && c2 != '}' && c2 != '\\') continue;
            int flushLn = i2 - writtenEnd;
            if (flushLn != 0) {
                out.write(s2, writtenEnd, flushLn);
            }
            out.write(92);
            writtenEnd = i2;
        }
        if (writtenEnd < ln) {
            out.write(s2, writtenEnd, ln - writtenEnd);
        }
    }

    public static String URLEnc(String s2, String charset) throws UnsupportedEncodingException {
        return StringUtil.URLEnc(s2, charset, false);
    }

    public static String URLPathEnc(String s2, String charset) throws UnsupportedEncodingException {
        return StringUtil.URLEnc(s2, charset, true);
    }

    private static String URLEnc(String s2, String charset, boolean keepSlash) throws UnsupportedEncodingException {
        char c2;
        int i2;
        int ln = s2.length();
        for (i2 = 0; i2 < ln && StringUtil.safeInURL(c2 = s2.charAt(i2), keepSlash); ++i2) {
        }
        if (i2 == ln) {
            return s2;
        }
        StringBuilder b2 = new StringBuilder(ln + ln / 3 + 2);
        b2.append(s2.substring(0, i2));
        int encStart = i2++;
        while (i2 < ln) {
            char c3 = s2.charAt(i2);
            if (StringUtil.safeInURL(c3, keepSlash)) {
                if (encStart != -1) {
                    byte[] o2 = s2.substring(encStart, i2).getBytes(charset);
                    for (int j2 = 0; j2 < o2.length; ++j2) {
                        b2.append('%');
                        byte bc = o2[j2];
                        int c1 = bc & 0xF;
                        int c22 = bc >> 4 & 0xF;
                        b2.append((char)(c22 < 10 ? c22 + 48 : c22 - 10 + 65));
                        b2.append((char)(c1 < 10 ? c1 + 48 : c1 - 10 + 65));
                    }
                    encStart = -1;
                }
                b2.append(c3);
            } else if (encStart == -1) {
                encStart = i2;
            }
            ++i2;
        }
        if (encStart != -1) {
            byte[] o3 = s2.substring(encStart, i2).getBytes(charset);
            for (int j3 = 0; j3 < o3.length; ++j3) {
                b2.append('%');
                byte bc = o3[j3];
                int c1 = bc & 0xF;
                int c23 = bc >> 4 & 0xF;
                b2.append((char)(c23 < 10 ? c23 + 48 : c23 - 10 + 65));
                b2.append((char)(c1 < 10 ? c1 + 48 : c1 - 10 + 65));
            }
        }
        return b2.toString();
    }

    private static boolean safeInURL(char c2, boolean keepSlash) {
        return c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9' || c2 == '_' || c2 == '-' || c2 == '.' || c2 == '!' || c2 == '~' || c2 >= '\'' && c2 <= '*' || keepSlash && c2 == '/';
    }

    private static char[] createEscapes() {
        char[] escapes = new char[93];
        for (int i2 = 0; i2 < 32; ++i2) {
            escapes[i2] = '\u0001';
        }
        escapes[92] = 92;
        escapes[39] = 39;
        escapes[34] = 34;
        escapes[60] = 108;
        escapes[62] = 103;
        escapes[38] = 97;
        escapes[8] = 98;
        escapes[9] = 116;
        escapes[10] = 110;
        escapes[12] = 102;
        escapes[13] = 114;
        return escapes;
    }

    public static String FTLStringLiteralEnc(String s2, char quotation) {
        return StringUtil.FTLStringLiteralEnc(s2, quotation, false);
    }

    public static String FTLStringLiteralEnc(String s2) {
        return StringUtil.FTLStringLiteralEnc(s2, '\u0000', false);
    }

    private static String FTLStringLiteralEnc(String s2, char quotation, boolean addQuotation) {
        int otherQuotation;
        int ln = s2.length();
        if (quotation == '\u0000') {
            otherQuotation = 0;
        } else if (quotation == '\"') {
            otherQuotation = 39;
        } else if (quotation == '\'') {
            otherQuotation = 34;
        } else {
            throw new IllegalArgumentException("Unsupported quotation character: " + quotation);
        }
        int escLn = ESCAPES.length;
        StringBuilder buf = null;
        for (int i2 = 0; i2 < ln; ++i2) {
            char c2 = s2.charAt(i2);
            char escape = c2 == '=' ? (i2 > 0 && s2.charAt(i2 - 1) == '[' ? (char)'=' : '\u0000') : (c2 < escLn ? ESCAPES[c2] : (c2 == '{' && i2 > 0 && StringUtil.isInterpolationStart(s2.charAt(i2 - 1)) ? (char)'{' : '\u0000'));
            if (escape == '\u0000' || escape == otherQuotation) {
                if (buf == null) continue;
                buf.append(c2);
                continue;
            }
            if (buf == null) {
                buf = new StringBuilder(s2.length() + 4 + (addQuotation ? 2 : 0));
                if (addQuotation) {
                    buf.append(quotation);
                }
                buf.append(s2.substring(0, i2));
            }
            if (escape == '\u0001') {
                buf.append("\\x00");
                int c22 = c2 >> 4 & 0xF;
                c2 = (char)(c2 & 0xF);
                buf.append((char)(c22 < 10 ? c22 + 48 : c22 - 10 + 65));
                buf.append((char)(c2 < '\n' ? c2 + 48 : c2 - 10 + 65));
                continue;
            }
            buf.append('\\');
            buf.append(escape);
        }
        if (buf == null) {
            return addQuotation ? quotation + s2 + quotation : s2;
        }
        if (addQuotation) {
            buf.append(quotation);
        }
        return buf.toString();
    }

    private static boolean isInterpolationStart(char c2) {
        return c2 == '$' || c2 == '#';
    }

    public static String FTLStringLiteralDec(String s2) throws ParseException {
        int idx = s2.indexOf(92);
        if (idx == -1) {
            return s2;
        }
        int lidx = s2.length() - 1;
        int bidx = 0;
        StringBuilder buf = new StringBuilder(lidx);
        do {
            buf.append(s2.substring(bidx, idx));
            if (idx >= lidx) {
                throw new ParseException("The last character of string literal is backslash", 0, 0);
            }
            char c2 = s2.charAt(idx + 1);
            switch (c2) {
                case '\"': {
                    buf.append('\"');
                    bidx = idx + 2;
                    break;
                }
                case '\'': {
                    buf.append('\'');
                    bidx = idx + 2;
                    break;
                }
                case '\\': {
                    buf.append('\\');
                    bidx = idx + 2;
                    break;
                }
                case 'n': {
                    buf.append('\n');
                    bidx = idx + 2;
                    break;
                }
                case 'r': {
                    buf.append('\r');
                    bidx = idx + 2;
                    break;
                }
                case 't': {
                    buf.append('\t');
                    bidx = idx + 2;
                    break;
                }
                case 'f': {
                    buf.append('\f');
                    bidx = idx + 2;
                    break;
                }
                case 'b': {
                    buf.append('\b');
                    bidx = idx + 2;
                    break;
                }
                case 'g': {
                    buf.append('>');
                    bidx = idx + 2;
                    break;
                }
                case 'l': {
                    buf.append('<');
                    bidx = idx + 2;
                    break;
                }
                case 'a': {
                    buf.append('&');
                    bidx = idx + 2;
                    break;
                }
                case '=': 
                case '{': {
                    buf.append(c2);
                    bidx = idx + 2;
                    break;
                }
                case 'x': {
                    int z2;
                    int x2 = idx += 2;
                    int y2 = 0;
                    int n2 = z2 = lidx > idx + 3 ? idx + 3 : lidx;
                    while (idx <= z2) {
                        char b2 = s2.charAt(idx);
                        if (b2 >= '0' && b2 <= '9') {
                            y2 <<= 4;
                            y2 += b2 - 48;
                        } else if (b2 >= 'a' && b2 <= 'f') {
                            y2 <<= 4;
                            y2 += b2 - 97 + 10;
                        } else {
                            if (b2 < 'A' || b2 > 'F') break;
                            y2 <<= 4;
                            y2 += b2 - 65 + 10;
                        }
                        ++idx;
                    }
                    if (x2 >= idx) {
                        throw new ParseException("Invalid \\x escape in a string literal", 0, 0);
                    }
                    buf.append((char)y2);
                    bidx = idx;
                    break;
                }
                default: {
                    throw new ParseException("Invalid escape sequence (\\" + c2 + ") in a string literal", 0, 0);
                }
            }
        } while ((idx = s2.indexOf(92, bidx)) != -1);
        buf.append(s2.substring(bidx));
        return buf.toString();
    }

    public static Locale deduceLocale(String input) {
        if (input == null) {
            return null;
        }
        Locale locale = Locale.getDefault();
        if (input.length() > 0 && input.charAt(0) == '\"') {
            input = input.substring(1, input.length() - 1);
        }
        StringTokenizer st = new StringTokenizer(input, ",_ ");
        String lang = "";
        String country = "";
        if (st.hasMoreTokens()) {
            lang = st.nextToken();
        }
        if (st.hasMoreTokens()) {
            country = st.nextToken();
        }
        locale = !st.hasMoreTokens() ? new Locale(lang, country) : new Locale(lang, country, st.nextToken());
        return locale;
    }

    public static String capitalize(String s2) {
        StringTokenizer st = new StringTokenizer(s2, " \t\r\n", true);
        StringBuilder buf = new StringBuilder(s2.length());
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            buf.append(tok.substring(0, 1).toUpperCase());
            buf.append(tok.substring(1).toLowerCase());
        }
        return buf.toString();
    }

    public static boolean getYesNo(String s2) {
        if (s2.startsWith("\"")) {
            s2 = s2.substring(1, s2.length() - 1);
        }
        if (s2.equalsIgnoreCase("n") || s2.equalsIgnoreCase("no") || s2.equalsIgnoreCase("f") || s2.equalsIgnoreCase("false")) {
            return false;
        }
        if (s2.equalsIgnoreCase("y") || s2.equalsIgnoreCase("yes") || s2.equalsIgnoreCase("t") || s2.equalsIgnoreCase("true")) {
            return true;
        }
        throw new IllegalArgumentException("Illegal boolean value: " + s2);
    }

    public static String[] split(String s2, char c2) {
        int ln = s2.length();
        int i2 = 0;
        int cnt = 1;
        while ((i2 = s2.indexOf(c2, i2)) != -1) {
            ++cnt;
            ++i2;
        }
        String[] res = new String[cnt];
        i2 = 0;
        int b2 = 0;
        while (b2 <= ln) {
            int e2 = s2.indexOf(c2, b2);
            if (e2 == -1) {
                e2 = ln;
            }
            res[i2++] = s2.substring(b2, e2);
            b2 = e2 + 1;
        }
        return res;
    }

    public static String[] split(String s2, String sep, boolean caseInsensitive) {
        int sepLn = sep.length();
        String convertedS = caseInsensitive ? s2.toLowerCase() : s2;
        int sLn = s2.length();
        if (sepLn == 0) {
            String[] res = new String[sLn];
            for (int i2 = 0; i2 < sLn; ++i2) {
                res[i2] = String.valueOf(s2.charAt(i2));
            }
            return res;
        }
        String splitString = caseInsensitive ? sep.toLowerCase() : sep;
        int next = 0;
        int count = 1;
        while ((next = convertedS.indexOf(splitString, next)) != -1) {
            ++count;
            next += sepLn;
        }
        String[] res = new String[count];
        int dst = 0;
        int next2 = 0;
        while (next2 <= sLn) {
            int end = convertedS.indexOf(splitString, next2);
            if (end == -1) {
                end = sLn;
            }
            res[dst++] = s2.substring(next2, end);
            next2 = end + sepLn;
        }
        return res;
    }

    public static String replace(String text, String oldSub, String newSub) {
        return StringUtil.replace(text, oldSub, newSub, false, false);
    }

    public static String replace(String text, String oldsub, String newsub, boolean caseInsensitive, boolean firstOnly) {
        int oln = oldsub.length();
        if (oln == 0) {
            int nln = newsub.length();
            if (nln == 0) {
                return text;
            }
            if (firstOnly) {
                return newsub + text;
            }
            int tln = text.length();
            StringBuilder buf = new StringBuilder(tln + (tln + 1) * nln);
            buf.append(newsub);
            for (int i2 = 0; i2 < tln; ++i2) {
                buf.append(text.charAt(i2));
                buf.append(newsub);
            }
            return buf.toString();
        }
        String input = caseInsensitive ? text.toLowerCase() : text;
        int e2 = input.indexOf(oldsub = caseInsensitive ? oldsub.toLowerCase() : oldsub);
        if (e2 == -1) {
            return text;
        }
        int b2 = 0;
        int tln = text.length();
        StringBuilder buf = new StringBuilder(tln + Math.max(newsub.length() - oln, 0) * 3);
        do {
            buf.append(text.substring(b2, e2));
            buf.append(newsub);
        } while ((e2 = input.indexOf(oldsub, b2 = e2 + oln)) != -1 && !firstOnly);
        buf.append(text.substring(b2));
        return buf.toString();
    }

    public static String chomp(String s2) {
        if (s2.endsWith("\r\n")) {
            return s2.substring(0, s2.length() - 2);
        }
        if (s2.endsWith("\r") || s2.endsWith("\n")) {
            return s2.substring(0, s2.length() - 1);
        }
        return s2;
    }

    public static String emptyToNull(String s2) {
        if (s2 == null) {
            return null;
        }
        return s2.length() == 0 ? null : s2;
    }

    public static String jQuote(Object obj) {
        return StringUtil.jQuote(obj != null ? obj.toString() : null);
    }

    public static String jQuote(String s2) {
        if (s2 == null) {
            return "null";
        }
        int ln = s2.length();
        StringBuilder b2 = new StringBuilder(ln + 4);
        b2.append('\"');
        for (int i2 = 0; i2 < ln; ++i2) {
            char c2 = s2.charAt(i2);
            if (c2 == '\"') {
                b2.append("\\\"");
                continue;
            }
            if (c2 == '\\') {
                b2.append("\\\\");
                continue;
            }
            if (c2 < ' ') {
                if (c2 == '\n') {
                    b2.append("\\n");
                    continue;
                }
                if (c2 == '\r') {
                    b2.append("\\r");
                    continue;
                }
                if (c2 == '\f') {
                    b2.append("\\f");
                    continue;
                }
                if (c2 == '\b') {
                    b2.append("\\b");
                    continue;
                }
                if (c2 == '\t') {
                    b2.append("\\t");
                    continue;
                }
                b2.append("\\u00");
                int x2 = c2 / 16;
                b2.append(StringUtil.toHexDigit(x2));
                x2 = c2 & 0xF;
                b2.append(StringUtil.toHexDigit(x2));
                continue;
            }
            b2.append(c2);
        }
        b2.append('\"');
        return b2.toString();
    }

    public static String jQuoteNoXSS(Object obj) {
        return StringUtil.jQuoteNoXSS(obj != null ? obj.toString() : null);
    }

    public static String jQuoteNoXSS(String s2) {
        if (s2 == null) {
            return "null";
        }
        int ln = s2.length();
        StringBuilder b2 = new StringBuilder(ln + 4);
        b2.append('\"');
        for (int i2 = 0; i2 < ln; ++i2) {
            char c2 = s2.charAt(i2);
            if (c2 == '\"') {
                b2.append("\\\"");
                continue;
            }
            if (c2 == '\\') {
                b2.append("\\\\");
                continue;
            }
            if (c2 == '<') {
                b2.append("\\u003C");
                continue;
            }
            if (c2 < ' ') {
                if (c2 == '\n') {
                    b2.append("\\n");
                    continue;
                }
                if (c2 == '\r') {
                    b2.append("\\r");
                    continue;
                }
                if (c2 == '\f') {
                    b2.append("\\f");
                    continue;
                }
                if (c2 == '\b') {
                    b2.append("\\b");
                    continue;
                }
                if (c2 == '\t') {
                    b2.append("\\t");
                    continue;
                }
                b2.append("\\u00");
                int x2 = c2 / 16;
                b2.append(StringUtil.toHexDigit(x2));
                x2 = c2 & 0xF;
                b2.append(StringUtil.toHexDigit(x2));
                continue;
            }
            b2.append(c2);
        }
        b2.append('\"');
        return b2.toString();
    }

    public static String ftlQuote(String s2) {
        int quotation = s2.indexOf(34) != -1 && s2.indexOf(39) == -1 ? 39 : 34;
        return StringUtil.FTLStringLiteralEnc(s2, (char)quotation, true);
    }

    public static boolean isFTLIdentifierStart(char c2) {
        if (c2 < '\u00aa') {
            if (c2 >= 'a' && c2 <= 'z' || c2 >= '@' && c2 <= 'Z') {
                return true;
            }
            return c2 == '$' || c2 == '_';
        }
        if (c2 < '\ua7f8') {
            if (c2 < '\u2d6f') {
                if (c2 < '\u2128') {
                    if (c2 < '\u2090') {
                        if (c2 < '\u00d8') {
                            if (c2 < '\u00ba') {
                                return c2 == '\u00aa' || c2 == '\u00b5';
                            }
                            return c2 == '\u00ba' || c2 >= '\u00c0' && c2 <= '\u00d6';
                        }
                        if (c2 < '\u2071') {
                            return c2 >= '\u00d8' && c2 <= '\u00f6' || c2 >= '\u00f8' && c2 <= '\u1fff';
                        }
                        return c2 == '\u2071' || c2 == '\u207f';
                    }
                    if (c2 < '\u2115') {
                        if (c2 < '\u2107') {
                            return c2 >= '\u2090' && c2 <= '\u209c' || c2 == '\u2102';
                        }
                        return c2 == '\u2107' || c2 >= '\u210a' && c2 <= '\u2113';
                    }
                    if (c2 < '\u2124') {
                        return c2 == '\u2115' || c2 >= '\u2119' && c2 <= '\u211d';
                    }
                    return c2 == '\u2124' || c2 == '\u2126';
                }
                if (c2 < '\u2c30') {
                    if (c2 < '\u2145') {
                        if (c2 < '\u212f') {
                            return c2 == '\u2128' || c2 >= '\u212a' && c2 <= '\u212d';
                        }
                        return c2 >= '\u212f' && c2 <= '\u2139' || c2 >= '\u213c' && c2 <= '\u213f';
                    }
                    if (c2 < '\u2183') {
                        return c2 >= '\u2145' && c2 <= '\u2149' || c2 == '\u214e';
                    }
                    return c2 >= '\u2183' && c2 <= '\u2184' || c2 >= '\u2c00' && c2 <= '\u2c2e';
                }
                if (c2 < '\u2d00') {
                    if (c2 < '\u2ceb') {
                        return c2 >= '\u2c30' && c2 <= '\u2c5e' || c2 >= '\u2c60' && c2 <= '\u2ce4';
                    }
                    return c2 >= '\u2ceb' && c2 <= '\u2cee' || c2 >= '\u2cf2' && c2 <= '\u2cf3';
                }
                if (c2 < '\u2d2d') {
                    return c2 >= '\u2d00' && c2 <= '\u2d25' || c2 == '\u2d27';
                }
                return c2 == '\u2d2d' || c2 >= '\u2d30' && c2 <= '\u2d67';
            }
            if (c2 < '\u31f0') {
                if (c2 < '\u2dd0') {
                    if (c2 < '\u2db0') {
                        if (c2 < '\u2da0') {
                            return c2 == '\u2d6f' || c2 >= '\u2d80' && c2 <= '\u2d96';
                        }
                        return c2 >= '\u2da0' && c2 <= '\u2da6' || c2 >= '\u2da8' && c2 <= '\u2dae';
                    }
                    if (c2 < '\u2dc0') {
                        return c2 >= '\u2db0' && c2 <= '\u2db6' || c2 >= '\u2db8' && c2 <= '\u2dbe';
                    }
                    return c2 >= '\u2dc0' && c2 <= '\u2dc6' || c2 >= '\u2dc8' && c2 <= '\u2dce';
                }
                if (c2 < '\u3031') {
                    if (c2 < '\u2e2f') {
                        return c2 >= '\u2dd0' && c2 <= '\u2dd6' || c2 >= '\u2dd8' && c2 <= '\u2dde';
                    }
                    return c2 == '\u2e2f' || c2 >= '\u3005' && c2 <= '\u3006';
                }
                if (c2 < '\u3040') {
                    return c2 >= '\u3031' && c2 <= '\u3035' || c2 >= '\u303b' && c2 <= '\u303c';
                }
                return c2 >= '\u3040' && c2 <= '\u318f' || c2 >= '\u31a0' && c2 <= '\u31ba';
            }
            if (c2 < '\ua67f') {
                if (c2 < '\ua4d0') {
                    if (c2 < '\u3400') {
                        return c2 >= '\u31f0' && c2 <= '\u31ff' || c2 >= '\u3300' && c2 <= '\u337f';
                    }
                    return c2 >= '\u3400' && c2 <= '\u4db5' || c2 >= '\u4e00' && c2 <= '\ua48c';
                }
                if (c2 < '\ua610') {
                    return c2 >= '\ua4d0' && c2 <= '\ua4fd' || c2 >= '\ua500' && c2 <= '\ua60c';
                }
                return c2 >= '\ua610' && c2 <= '\ua62b' || c2 >= '\ua640' && c2 <= '\ua66e';
            }
            if (c2 < '\ua78b') {
                if (c2 < '\ua717') {
                    return c2 >= '\ua67f' && c2 <= '\ua697' || c2 >= '\ua6a0' && c2 <= '\ua6e5';
                }
                return c2 >= '\ua717' && c2 <= '\ua71f' || c2 >= '\ua722' && c2 <= '\ua788';
            }
            if (c2 < '\ua7a0') {
                return c2 >= '\ua78b' && c2 <= '\ua78e' || c2 >= '\ua790' && c2 <= '\ua793';
            }
            return c2 >= '\ua7a0' && c2 <= '\ua7aa';
        }
        if (c2 < '\uab20') {
            if (c2 < '\uaa44') {
                if (c2 < '\ua8fb') {
                    if (c2 < '\ua840') {
                        if (c2 < '\ua807') {
                            return c2 >= '\ua7f8' && c2 <= '\ua801' || c2 >= '\ua803' && c2 <= '\ua805';
                        }
                        return c2 >= '\ua807' && c2 <= '\ua80a' || c2 >= '\ua80c' && c2 <= '\ua822';
                    }
                    if (c2 < '\ua8d0') {
                        return c2 >= '\ua840' && c2 <= '\ua873' || c2 >= '\ua882' && c2 <= '\ua8b3';
                    }
                    return c2 >= '\ua8d0' && c2 <= '\ua8d9' || c2 >= '\ua8f2' && c2 <= '\ua8f7';
                }
                if (c2 < '\ua984') {
                    if (c2 < '\ua930') {
                        return c2 == '\ua8fb' || c2 >= '\ua900' && c2 <= '\ua925';
                    }
                    return c2 >= '\ua930' && c2 <= '\ua946' || c2 >= '\ua960' && c2 <= '\ua97c';
                }
                if (c2 < '\uaa00') {
                    return c2 >= '\ua984' && c2 <= '\ua9b2' || c2 >= '\ua9cf' && c2 <= '\ua9d9';
                }
                return c2 >= '\uaa00' && c2 <= '\uaa28' || c2 >= '\uaa40' && c2 <= '\uaa42';
            }
            if (c2 < '\uaac0') {
                if (c2 < '\uaa80') {
                    if (c2 < '\uaa60') {
                        return c2 >= '\uaa44' && c2 <= '\uaa4b' || c2 >= '\uaa50' && c2 <= '\uaa59';
                    }
                    return c2 >= '\uaa60' && c2 <= '\uaa76' || c2 == '\uaa7a';
                }
                if (c2 < '\uaab5') {
                    return c2 >= '\uaa80' && c2 <= '\uaaaf' || c2 == '\uaab1';
                }
                return c2 >= '\uaab5' && c2 <= '\uaab6' || c2 >= '\uaab9' && c2 <= '\uaabd';
            }
            if (c2 < '\uaaf2') {
                if (c2 < '\uaadb') {
                    return c2 == '\uaac0' || c2 == '\uaac2';
                }
                return c2 >= '\uaadb' && c2 <= '\uaadd' || c2 >= '\uaae0' && c2 <= '\uaaea';
            }
            if (c2 < '\uab09') {
                return c2 >= '\uaaf2' && c2 <= '\uaaf4' || c2 >= '\uab01' && c2 <= '\uab06';
            }
            return c2 >= '\uab09' && c2 <= '\uab0e' || c2 >= '\uab11' && c2 <= '\uab16';
        }
        if (c2 < '\ufb46') {
            if (c2 < '\ufb13') {
                if (c2 < '\uac00') {
                    if (c2 < '\uabc0') {
                        return c2 >= '\uab20' && c2 <= '\uab26' || c2 >= '\uab28' && c2 <= '\uab2e';
                    }
                    return c2 >= '\uabc0' && c2 <= '\uabe2' || c2 >= '\uabf0' && c2 <= '\uabf9';
                }
                if (c2 < '\ud7cb') {
                    return c2 >= '\uac00' && c2 <= '\ud7a3' || c2 >= '\ud7b0' && c2 <= '\ud7c6';
                }
                return c2 >= '\ud7cb' && c2 <= '\ud7fb' || c2 >= '\uf900' && c2 <= '\ufb06';
            }
            if (c2 < '\ufb38') {
                if (c2 < '\ufb1f') {
                    return c2 >= '\ufb13' && c2 <= '\ufb17' || c2 == '\ufb1d';
                }
                return c2 >= '\ufb1f' && c2 <= '\ufb28' || c2 >= '\ufb2a' && c2 <= '\ufb36';
            }
            if (c2 < '\ufb40') {
                return c2 >= '\ufb38' && c2 <= '\ufb3c' || c2 == '\ufb3e';
            }
            return c2 >= '\ufb40' && c2 <= '\ufb41' || c2 >= '\ufb43' && c2 <= '\ufb44';
        }
        if (c2 < '\uff21') {
            if (c2 < '\ufdf0') {
                if (c2 < '\ufd50') {
                    return c2 >= '\ufb46' && c2 <= '\ufbb1' || c2 >= '\ufbd3' && c2 <= '\ufd3d';
                }
                return c2 >= '\ufd50' && c2 <= '\ufd8f' || c2 >= '\ufd92' && c2 <= '\ufdc7';
            }
            if (c2 < '\ufe76') {
                return c2 >= '\ufdf0' && c2 <= '\ufdfb' || c2 >= '\ufe70' && c2 <= '\ufe74';
            }
            return c2 >= '\ufe76' && c2 <= '\ufefc' || c2 >= '\uff10' && c2 <= '\uff19';
        }
        if (c2 < '\uffca') {
            if (c2 < '\uff66') {
                return c2 >= '\uff21' && c2 <= '\uff3a' || c2 >= '\uff41' && c2 <= '\uff5a';
            }
            return c2 >= '\uff66' && c2 <= '\uffbe' || c2 >= '\uffc2' && c2 <= '\uffc7';
        }
        if (c2 < '\uffda') {
            return c2 >= '\uffca' && c2 <= '\uffcf' || c2 >= '\uffd2' && c2 <= '\uffd7';
        }
        return c2 >= '\uffda' && c2 <= '\uffdc';
    }

    public static boolean isFTLIdentifierPart(char c2) {
        return StringUtil.isFTLIdentifierStart(c2) || c2 >= '0' && c2 <= '9';
    }

    public static String javaStringEnc(String s2) {
        int ln = s2.length();
        for (int i2 = 0; i2 < ln; ++i2) {
            char c2 = s2.charAt(i2);
            if (c2 != '\"' && c2 != '\\' && c2 >= ' ') continue;
            StringBuilder b2 = new StringBuilder(ln + 4);
            b2.append(s2.substring(0, i2));
            while (true) {
                if (c2 == '\"') {
                    b2.append("\\\"");
                } else if (c2 == '\\') {
                    b2.append("\\\\");
                } else if (c2 < ' ') {
                    if (c2 == '\n') {
                        b2.append("\\n");
                    } else if (c2 == '\r') {
                        b2.append("\\r");
                    } else if (c2 == '\f') {
                        b2.append("\\f");
                    } else if (c2 == '\b') {
                        b2.append("\\b");
                    } else if (c2 == '\t') {
                        b2.append("\\t");
                    } else {
                        b2.append("\\u00");
                        int x2 = c2 / 16;
                        b2.append((char)(x2 < 10 ? x2 + 48 : x2 - 10 + 97));
                        x2 = c2 & 0xF;
                        b2.append((char)(x2 < 10 ? x2 + 48 : x2 - 10 + 97));
                    }
                } else {
                    b2.append(c2);
                }
                if (++i2 >= ln) {
                    return b2.toString();
                }
                c2 = s2.charAt(i2);
            }
        }
        return s2;
    }

    public static String javaScriptStringEnc(String s2) {
        return StringUtil.jsStringEnc(s2, false);
    }

    public static String jsonStringEnc(String s2) {
        return StringUtil.jsStringEnc(s2, true);
    }

    public static String jsStringEnc(String s2, boolean json) {
        NullArgumentException.check("s", s2);
        int ln = s2.length();
        StringBuilder sb = null;
        for (int i2 = 0; i2 < ln; ++i2) {
            char c2 = s2.charAt(i2);
            if (!(c2 > '>' && c2 < '\u007f' && c2 != '\\' || c2 == ' ' || c2 >= '\u00a0' && c2 < '\u2028')) {
                boolean dangerous;
                int escapeType;
                if (c2 <= '\u001f') {
                    escapeType = c2 == '\n' ? 110 : (c2 == '\r' ? 114 : (c2 == '\f' ? 102 : (c2 == '\b' ? 98 : (c2 == '\t' ? 116 : 1))));
                } else if (c2 == '\"') {
                    escapeType = 3;
                } else if (c2 == '\'') {
                    escapeType = json ? 0 : 3;
                } else if (c2 == '\\') {
                    escapeType = 3;
                } else if (c2 == '/' && (i2 == 0 || s2.charAt(i2 - 1) == '<')) {
                    escapeType = 3;
                } else if (c2 == '>') {
                    char prevPrevC;
                    char prevC;
                    dangerous = i2 == 0 ? true : ((prevC = s2.charAt(i2 - 1)) == ']' || prevC == '-' ? (i2 == 1 ? true : (prevPrevC = s2.charAt(i2 - 2)) == prevC) : false);
                    escapeType = dangerous ? (json ? 1 : 3) : 0;
                } else if (c2 == '<') {
                    char nextC;
                    dangerous = i2 == ln - 1 ? true : (nextC = s2.charAt(i2 + 1)) == '!' || nextC == '?';
                    escapeType = dangerous ? 1 : 0;
                } else {
                    escapeType = c2 >= '\u007f' && c2 <= '\u009f' || c2 == '\u2028' || c2 == '\u2029' ? 1 : 0;
                }
                if (escapeType != 0) {
                    if (sb == null) {
                        sb = new StringBuilder(ln + 6);
                        sb.append(s2.substring(0, i2));
                    }
                    sb.append('\\');
                    if (escapeType > 32) {
                        sb.append((char)escapeType);
                        continue;
                    }
                    if (escapeType == 1) {
                        if (!json && c2 < '\u0100') {
                            sb.append('x');
                            sb.append(StringUtil.toHexDigit(c2 >> 4));
                            sb.append(StringUtil.toHexDigit(c2 & 0xF));
                            continue;
                        }
                        sb.append('u');
                        char cp = c2;
                        sb.append(StringUtil.toHexDigit(cp >> 12 & 0xF));
                        sb.append(StringUtil.toHexDigit(cp >> 8 & 0xF));
                        sb.append(StringUtil.toHexDigit(cp >> 4 & 0xF));
                        sb.append(StringUtil.toHexDigit(cp & 0xF));
                        continue;
                    }
                    sb.append(c2);
                    continue;
                }
            }
            if (sb == null) continue;
            sb.append(c2);
        }
        return sb == null ? s2 : sb.toString();
    }

    private static char toHexDigit(int d2) {
        return (char)(d2 < 10 ? d2 + 48 : d2 - 10 + 65);
    }

    public static Map parseNameValuePairList(String s2, String defaultValue) throws java.text.ParseException {
        HashMap<String, String> map;
        block18: {
            String key;
            int keyStart;
            map = new HashMap<String, String>();
            char c2 = ' ';
            int ln = s2.length();
            int p2 = 0;
            while (true) {
                String value;
                if (p2 < ln && Character.isWhitespace(c2 = (char)s2.charAt(p2))) {
                    ++p2;
                    continue;
                }
                if (p2 == ln) break block18;
                keyStart = p2;
                while (p2 < ln && (Character.isLetterOrDigit(c2 = s2.charAt(p2)) || c2 == '_')) {
                    ++p2;
                }
                if (keyStart == p2) {
                    throw new java.text.ParseException("Expecting letter, digit or \"_\" here, (the first character of the key) but found " + StringUtil.jQuote(String.valueOf(c2)) + " at position " + p2 + ".", p2);
                }
                key = s2.substring(keyStart, p2);
                while (p2 < ln && Character.isWhitespace(c2 = s2.charAt(p2))) {
                    ++p2;
                }
                if (p2 == ln) {
                    if (defaultValue == null) {
                        throw new java.text.ParseException("Expecting \":\", but reached the end of the string  at position " + p2 + ".", p2);
                    }
                    value = defaultValue;
                } else if (c2 != ':') {
                    if (defaultValue == null || c2 != ',') {
                        throw new java.text.ParseException("Expecting \":\" here, but found " + StringUtil.jQuote(String.valueOf(c2)) + " at position " + p2 + ".", p2);
                    }
                    ++p2;
                    value = defaultValue;
                } else {
                    ++p2;
                    while (p2 < ln && Character.isWhitespace(c2 = s2.charAt(p2))) {
                        ++p2;
                    }
                    if (p2 == ln) {
                        throw new java.text.ParseException("Expecting the value of the key here, but reached the end of the string  at position " + p2 + ".", p2);
                    }
                    int valueStart = p2;
                    while (p2 < ln && (Character.isLetterOrDigit(c2 = s2.charAt(p2)) || c2 == '_')) {
                        ++p2;
                    }
                    if (valueStart == p2) {
                        throw new java.text.ParseException("Expecting letter, digit or \"_\" here, (the first character of the value) but found " + StringUtil.jQuote(String.valueOf(c2)) + " at position " + p2 + ".", p2);
                    }
                    value = s2.substring(valueStart, p2);
                    while (p2 < ln && Character.isWhitespace(c2 = s2.charAt(p2))) {
                        ++p2;
                    }
                    if (p2 < ln) {
                        if (c2 != ',') {
                            throw new java.text.ParseException("Excpecting \",\" or the end of the string here, but found " + StringUtil.jQuote(String.valueOf(c2)) + " at position " + p2 + ".", p2);
                        }
                        ++p2;
                    }
                }
                if (map.put(key, value) != null) break;
            }
            throw new java.text.ParseException("Dublicated key: " + StringUtil.jQuote(key), keyStart);
        }
        return map;
    }

    @Deprecated
    public static boolean isXMLID(String name) {
        return _ExtDomApi.isXMLNameLike(name);
    }

    public static boolean matchesName(String qname, String nodeName, String nsURI, Environment env) {
        return _ExtDomApi.matchesName(qname, nodeName, nsURI, env);
    }

    public static String leftPad(String s2, int minLength) {
        return StringUtil.leftPad(s2, minLength, ' ');
    }

    public static String leftPad(String s2, int minLength, char filling) {
        int ln = s2.length();
        if (minLength <= ln) {
            return s2;
        }
        StringBuilder res = new StringBuilder(minLength);
        int dif = minLength - ln;
        for (int i2 = 0; i2 < dif; ++i2) {
            res.append(filling);
        }
        res.append(s2);
        return res.toString();
    }

    public static String leftPad(String s2, int minLength, String filling) {
        int i2;
        int ln = s2.length();
        if (minLength <= ln) {
            return s2;
        }
        StringBuilder res = new StringBuilder(minLength);
        int dif = minLength - ln;
        int fln = filling.length();
        if (fln == 0) {
            throw new IllegalArgumentException("The \"filling\" argument can't be 0 length string.");
        }
        int cnt = dif / fln;
        for (i2 = 0; i2 < cnt; ++i2) {
            res.append(filling);
        }
        cnt = dif % fln;
        for (i2 = 0; i2 < cnt; ++i2) {
            res.append(filling.charAt(i2));
        }
        res.append(s2);
        return res.toString();
    }

    public static String rightPad(String s2, int minLength) {
        return StringUtil.rightPad(s2, minLength, ' ');
    }

    public static String rightPad(String s2, int minLength, char filling) {
        int ln = s2.length();
        if (minLength <= ln) {
            return s2;
        }
        StringBuilder res = new StringBuilder(minLength);
        res.append(s2);
        int dif = minLength - ln;
        for (int i2 = 0; i2 < dif; ++i2) {
            res.append(filling);
        }
        return res.toString();
    }

    public static String rightPad(String s2, int minLength, String filling) {
        int i2;
        int ln = s2.length();
        if (minLength <= ln) {
            return s2;
        }
        StringBuilder res = new StringBuilder(minLength);
        res.append(s2);
        int dif = minLength - ln;
        int fln = filling.length();
        if (fln == 0) {
            throw new IllegalArgumentException("The \"filling\" argument can't be 0 length string.");
        }
        int start = ln % fln;
        int end = fln - start <= dif ? fln : start + dif;
        for (int i3 = start; i3 < end; ++i3) {
            res.append(filling.charAt(i3));
        }
        int cnt = (dif -= end - start) / fln;
        for (i2 = 0; i2 < cnt; ++i2) {
            res.append(filling);
        }
        cnt = dif % fln;
        for (i2 = 0; i2 < cnt; ++i2) {
            res.append(filling.charAt(i2));
        }
        return res.toString();
    }

    public static int versionStringToInt(String version) {
        return new Version(version).intValue();
    }

    public static String tryToString(Object object) {
        if (object == null) {
            return null;
        }
        try {
            return object.toString();
        }
        catch (Throwable e2) {
            return StringUtil.failedToStringSubstitute(object, e2);
        }
    }

    private static String failedToStringSubstitute(Object object, Throwable e2) {
        String eStr;
        try {
            eStr = e2.toString();
        }
        catch (Throwable e22) {
            eStr = ClassUtil.getShortClassNameOfObject(e2);
        }
        return "[" + ClassUtil.getShortClassNameOfObject(object) + ".toString() failed: " + eStr + "]";
    }

    public static String toUpperABC(int n2) {
        return StringUtil.toABC(n2, 'A');
    }

    public static String toLowerABC(int n2) {
        return StringUtil.toABC(n2, 'a');
    }

    private static String toABC(int n2, char oneDigit) {
        int nextWeight;
        int nextReached;
        if (n2 < 1) {
            throw new IllegalArgumentException("Can't convert 0 or negative numbers to latin-number: " + n2);
        }
        int reached = 1;
        int weight = 1;
        while ((nextReached = reached + (nextWeight = weight * 26)) <= n2) {
            weight = nextWeight;
            reached = nextReached;
        }
        StringBuilder sb = new StringBuilder();
        while (weight != 0) {
            int digitIncrease = (n2 - reached) / weight;
            sb.append((char)(oneDigit + digitIncrease));
            reached += digitIncrease * weight;
            weight /= 26;
        }
        return sb.toString();
    }

    public static char[] trim(char[] cs) {
        int start;
        if (cs.length == 0) {
            return cs;
        }
        int end = cs.length;
        for (start = 0; start < end && cs[start] <= ' '; ++start) {
        }
        while (start < end && cs[end - 1] <= ' ') {
            --end;
        }
        if (start == 0 && end == cs.length) {
            return cs;
        }
        if (start == end) {
            return CollectionUtils.EMPTY_CHAR_ARRAY;
        }
        char[] newCs = new char[end - start];
        System.arraycopy(cs, start, newCs, 0, end - start);
        return newCs;
    }

    public static boolean isTrimmableToEmpty(char[] text) {
        return StringUtil.isTrimmableToEmpty(text, 0, text.length);
    }

    public static boolean isTrimmableToEmpty(char[] text, int start) {
        return StringUtil.isTrimmableToEmpty(text, start, text.length);
    }

    public static boolean isTrimmableToEmpty(char[] text, int start, int end) {
        for (int i2 = start; i2 < end; ++i2) {
            if (text[i2] <= ' ') continue;
            return false;
        }
        return true;
    }

    public static Pattern globToRegularExpression(String glob) {
        return StringUtil.globToRegularExpression(glob, false);
    }

    public static Pattern globToRegularExpression(String glob, boolean caseInsensitive) {
        StringBuilder regex = new StringBuilder();
        int nextStart = 0;
        boolean escaped = false;
        int ln = glob.length();
        for (int idx = 0; idx < ln; ++idx) {
            char c2 = glob.charAt(idx);
            if (!escaped) {
                if (c2 == '?') {
                    StringUtil.appendLiteralGlobSection(regex, glob, nextStart, idx);
                    regex.append("[^/]");
                    nextStart = idx + 1;
                    continue;
                }
                if (c2 == '*') {
                    StringUtil.appendLiteralGlobSection(regex, glob, nextStart, idx);
                    if (idx + 1 < ln && glob.charAt(idx + 1) == '*') {
                        if (idx != 0 && glob.charAt(idx - 1) != '/') {
                            throw new IllegalArgumentException("The \"**\" wildcard must be directly after a \"/\" or it must be at the beginning, in this glob: " + glob);
                        }
                        if (idx + 2 == ln) {
                            regex.append(".*");
                            ++idx;
                        } else {
                            if (idx + 2 >= ln || glob.charAt(idx + 2) != '/') {
                                throw new IllegalArgumentException("The \"**\" wildcard must be followed by \"/\", or must be at tehe end, in this glob: " + glob);
                            }
                            regex.append("(.*?/)*");
                            idx += 2;
                        }
                    } else {
                        regex.append("[^/]*");
                    }
                    nextStart = idx + 1;
                    continue;
                }
                if (c2 == '\\') {
                    escaped = true;
                    continue;
                }
                if (c2 != '[' && c2 != '{') continue;
                throw new IllegalArgumentException("The \"" + c2 + "\" glob operator is currently unsupported (precede it with \\ for literal matching), in this glob: " + glob);
            }
            escaped = false;
        }
        StringUtil.appendLiteralGlobSection(regex, glob, nextStart, glob.length());
        return Pattern.compile(regex.toString(), caseInsensitive ? 66 : 0);
    }

    private static void appendLiteralGlobSection(StringBuilder regex, String glob, int start, int end) {
        if (start == end) {
            return;
        }
        String part = StringUtil.unescapeLiteralGlobSection(glob.substring(start, end));
        regex.append(Pattern.quote(part));
    }

    private static String unescapeLiteralGlobSection(String s2) {
        int backslashIdx = s2.indexOf(92);
        if (backslashIdx == -1) {
            return s2;
        }
        int ln = s2.length();
        StringBuilder sb = new StringBuilder(ln - 1);
        int nextStart = 0;
        do {
            sb.append(s2, nextStart, backslashIdx);
        } while ((backslashIdx = s2.indexOf(92, (nextStart = backslashIdx + 1) + 1)) != -1);
        if (nextStart < ln) {
            sb.append(s2, nextStart, ln);
        }
        return sb.toString();
    }
}

