/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.io;

import java.security.Security;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;

public final class SerialFilterChecker {
    private static final Log log;
    private static final String JDK_SERIAL_FILTER = "jdk.serialFilter";
    private static final boolean SERIAL_FILTER_MISSING;
    private static boolean firstInvocation;

    public static void check() {
        if (firstInvocation && SERIAL_FILTER_MISSING) {
            firstInvocation = false;
            log.warn("As you are using functionality that deserializes object streams, it is recommended to define the JEP-290 serial filter. Please refer to https://docs.oracle.com/pls/topic/lookup?ctx=javase15&id=GUID-8296D8E8-2B93-4B9A-856E-0A65AF9B8C66");
        }
    }

    private SerialFilterChecker() {
    }

    static {
        Object serialFilter;
        log = LogFactory.getLog(SerialFilterChecker.class);
        firstInvocation = true;
        try {
            Class<?> objectFilterConfig = Class.forName("java.io.ObjectInputFilter$Config");
            serialFilter = objectFilterConfig.getMethod("getSerialFilter", new Class[0]).invoke(null, new Object[0]);
        }
        catch (ReflectiveOperationException e2) {
            serialFilter = System.getProperty(JDK_SERIAL_FILTER, Security.getProperty(JDK_SERIAL_FILTER));
        }
        SERIAL_FILTER_MISSING = serialFilter == null;
    }
}

