/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.plugin;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.PluginException;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.ExceptionUtil;
import org.apache.ibatis.util.MapUtil;

public class Plugin
implements InvocationHandler {
    private final Object target;
    private final Interceptor interceptor;
    private final Map<Class<?>, Set<Method>> signatureMap;

    private Plugin(Object target, Interceptor interceptor, Map<Class<?>, Set<Method>> signatureMap) {
        this.target = target;
        this.interceptor = interceptor;
        this.signatureMap = signatureMap;
    }

    public static Object wrap(Object target, Interceptor interceptor) {
        Map<Class<?>, Set<Method>> signatureMap = Plugin.getSignatureMap(interceptor);
        Class<?> type = target.getClass();
        Class<?>[] interfaces = Plugin.getAllInterfaces(type, signatureMap);
        if (interfaces.length > 0) {
            return Proxy.newProxyInstance(type.getClassLoader(), interfaces, (InvocationHandler)new Plugin(target, interceptor, signatureMap));
        }
        return target;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            Set<Method> methods = this.signatureMap.get(method.getDeclaringClass());
            if (methods != null && methods.contains(method)) {
                return this.interceptor.intercept(new Invocation(this.target, method, args));
            }
            return method.invoke(this.target, args);
        }
        catch (Exception e2) {
            throw ExceptionUtil.unwrapThrowable(e2);
        }
    }

    private static Map<Class<?>, Set<Method>> getSignatureMap(Interceptor interceptor) {
        Intercepts interceptsAnnotation = interceptor.getClass().getAnnotation(Intercepts.class);
        if (interceptsAnnotation == null) {
            throw new PluginException("No @Intercepts annotation was found in interceptor " + interceptor.getClass().getName());
        }
        Signature[] sigs = interceptsAnnotation.value();
        HashMap signatureMap = new HashMap();
        for (Signature sig : sigs) {
            Set methods = MapUtil.computeIfAbsent(signatureMap, sig.type(), k2 -> new HashSet());
            try {
                Method method = sig.type().getMethod(sig.method(), sig.args());
                methods.add(method);
            }
            catch (NoSuchMethodException e2) {
                throw new PluginException("Could not find method on " + sig.type() + " named " + sig.method() + ". Cause: " + e2, e2);
            }
        }
        return signatureMap;
    }

    private static Class<?>[] getAllInterfaces(Class<?> type, Map<Class<?>, Set<Method>> signatureMap) {
        HashSet interfaces = new HashSet();
        while (type != null) {
            for (Class<?> c2 : type.getInterfaces()) {
                if (!signatureMap.containsKey(c2)) continue;
                interfaces.add(c2);
            }
            type = type.getSuperclass();
        }
        return interfaces.toArray(new Class[0]);
    }
}

