/*
 * Decompiled with CFR 0.152.
 */
package top.thinkin.lightd.raft;

import com.alipay.remoting.exception.CodecException;
import com.alipay.remoting.serialization.SerializerManager;
import com.alipay.sofa.jraft.Closure;
import com.alipay.sofa.jraft.entity.Task;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.thinkin.lightd.base.DBCommandChunk;
import top.thinkin.lightd.db.DBAbs;
import top.thinkin.lightd.exception.ErrorType;
import top.thinkin.lightd.exception.KitDBException;
import top.thinkin.lightd.raft.DBClosure;
import top.thinkin.lightd.raft.KitRaft;

public class DBRequestProcessor
implements DBAbs.FunctionCommit {
    ConcurrentHashMap<Object, String> map = new ConcurrentHashMap();
    private static final Logger LOG = LoggerFactory.getLogger(DBRequestProcessor.class);
    private final KitRaft kitRaft;

    public DBRequestProcessor(KitRaft kitRaft) {
        this.kitRaft = kitRaft;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(DBCommandChunk dbCommandChunk) throws CodecException, InterruptedException, KitDBException {
        DBClosure closure = new DBClosure();
        closure.setChunk(dbCommandChunk);
        Task task = new Task();
        task.setDone((Closure)closure);
        task.setData(ByteBuffer.wrap(SerializerManager.getSerializer((int)1).serialize((Object)dbCommandChunk)));
        this.kitRaft.getNode().apply(task);
        DBClosure dBClosure = closure;
        synchronized (dBClosure) {
            closure.wait();
        }
        if (closure.getCode() != 0) {
            throw new KitDBException(ErrorType.STROE_ERROR, closure.getMsg());
        }
    }

    public void call(DBCommandChunk dbCommandChunk) throws KitDBException {
        try {
            this.handle(dbCommandChunk);
        }
        catch (CodecException | InterruptedException e) {
            throw new KitDBException(ErrorType.STROE_ERROR, (Exception)e);
        }
    }
}

